/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.dynamicobject;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public abstract class DynamicObjectLanguageHeapFragment<D extends DynamicObject, T extends TruffleType<D>>
extends TruffleLanguageHeapFragment<D, T> {
    private final Map<Instance, JavaClass> languageIDsCache = new HashMap<Instance, JavaClass>();

    protected DynamicObjectLanguageHeapFragment(String ID, String name, String description, TruffleLanguage<D, T, ? extends TruffleLanguageHeapFragment<D, T>> language, Heap heap) {
        super(ID, name, description, language, heap);
    }

    protected final Iterator<Instance> languageInstancesIterator(String languageID) {
        Iterator instIt = HeapUtils.instancesIterator((Collection)HeapUtils.getSubclasses((Heap)this.heap, (String)"com.oracle.truffle.api.object.DynamicObject"));
        return new LanguageInstanceFilterIterator(instIt, languageID);
    }

    protected final Iterator<D> languageObjectsIterator(String languageID) {
        TruffleLanguageHeapFragment.ObjectsIterator dynIt = (TruffleLanguageHeapFragment)this.new TruffleLanguageHeapFragment.ObjectsIterator(HeapUtils.getSubclasses((Heap)this.heap, (String)"com.oracle.truffle.api.object.DynamicObject"));
        return new LanguageFilterIterator(dynIt, languageID);
    }

    private JavaClass getLanguageID(Instance shape) {
        JavaClass langID = this.languageIDsCache.get(shape);
        if (langID == null) {
            langID = DynamicObject.getLanguageIdFromShape(shape);
            this.languageIDsCache.put(shape, langID);
        }
        return langID;
    }

    private class LanguageInstanceFilterIterator
    implements Iterator<Instance> {
        private final String languageID;
        private final Iterator<Instance> instancesIterator;
        private Instance next;

        private LanguageInstanceFilterIterator(Iterator<Instance> instIt, String langID) {
            this.instancesIterator = instIt;
            this.languageID = langID;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.instancesIterator.hasNext()) {
                Instance inst = this.instancesIterator.next();
                Instance shape = DynamicObject.getShape(inst);
                JavaClass langId = DynamicObjectLanguageHeapFragment.this.getLanguageID(shape);
                if (langId == null || !this.languageID.equals(langId.getName())) continue;
                this.next = inst;
                return true;
            }
            return false;
        }

        @Override
        public Instance next() {
            if (this.hasNext()) {
                Instance inst = this.next;
                this.next = null;
                return inst;
            }
            throw new NoSuchElementException();
        }
    }

    private class LanguageFilterIterator
    implements Iterator<D> {
        private final String languageID;
        private final Iterator<D> objIterator;
        private D next;

        private LanguageFilterIterator(Iterator<D> oit, String langID) {
            this.objIterator = oit;
            this.languageID = langID;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.objIterator.hasNext()) {
                DynamicObject dobj = (DynamicObject)this.objIterator.next();
                Instance shape = dobj.getShape();
                if (!this.languageID.equals(DynamicObjectLanguageHeapFragment.this.getLanguageID(shape).getName())) continue;
                this.next = dobj;
                return true;
            }
            return false;
        }

        @Override
        public D next() {
            if (this.hasNext()) {
                Object dobj = this.next;
                this.next = null;
                return dobj;
            }
            throw new NoSuchElementException();
        }
    }
}

