/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.python;

import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.openide.util.Lookup;

public class PythonLanguage
extends TruffleLanguage<PythonObject, PythonType, PythonHeapFragment> {
    private static final String ID = "python";
    private static final String PYTHON_LANGINFO_ID_OLD = "python";
    private static final String PYTHON_LANGINFO_ID = "Python";
    private static PythonLanguage INSTANCE;

    static synchronized PythonLanguage instance() {
        if (INSTANCE == null) {
            Lookup.getDefault().lookup(PythonLanguage.class);
        }
        return INSTANCE;
    }

    public PythonLanguage() {
        INSTANCE = this;
    }

    @Override
    public String getID() {
        return "python";
    }

    @Override
    protected PythonHeapFragment createFragment(Heap heap) {
        Instance langID = PythonLanguage.getLanguageInfo(heap, PYTHON_LANGINFO_ID);
        if (langID == null) {
            langID = PythonLanguage.getLanguageInfo(heap, "python");
        }
        if (langID == null) {
            return null;
        }
        JavaClass pythonMainClass = heap.getJavaClassByName("com.oracle.graal.python.builtins.objects.object.PythonObject");
        if (pythonMainClass == null) {
            return null;
        }
        return new PythonHeapFragment(this, langID, heap);
    }

    @Override
    public Class<PythonObject> getLanguageObjectClass() {
        return PythonObject.class;
    }

    @Override
    public boolean isLanguageObject(Instance instance) {
        return PythonObject.isPythonObject(instance);
    }

    @Override
    public PythonObject createObject(Instance instance) {
        return new PythonObject(instance);
    }

    @Override
    public PythonType createType(String name) {
        return new PythonType(name);
    }

    public PythonNodes.PythonObjectNode createObjectNode(PythonObject object, String type) {
        return new PythonNodes.PythonObjectNode(object, type);
    }

    public PythonNodes.PythonLocalObjectNode createLocalObjectNode(PythonObject object, String type) {
        return new PythonNodes.PythonLocalObjectNode(object, type);
    }

    public PythonNodes.PythonTypeNode createTypeNode(PythonType type, Heap heap) {
        return new PythonNodes.PythonTypeNode(type);
    }
}

