/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.graalvm.visualvm.lib.ui.swing.FilteringToolbar;
import org.graalvm.visualvm.lib.ui.swing.ProfilerPopup;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.SmallButton;
import org.graalvm.visualvm.lib.ui.swing.renderer.CheckBoxRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.openide.util.Lookup;

abstract class TablesSelector {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.jdbc.Bundle");
    private static final String SELECT_TABLES = messages.getString("TablesSelector_SelectTables");
    private static final String FILTER_TABLES = messages.getString("TablesSelector_FilterTables");
    private static final String COLUMN_SELECTED = messages.getString("TablesSelector_ColumnSelected");
    private static final String COLUMN_TABLE = messages.getString("TablesSelector_ColumnTable");
    private static final String COLUMN_SELECTED_TOOLTIP = messages.getString("TablesSelector_ColumnSelectedToolTip");
    private static final String COLUMN_TABLE_TOOLTIP = messages.getString("TablesSelector_ColumnTableToolTip");
    private static final String ACT_SELECT_ALL = messages.getString("TablesSelector_ActSelectAll");
    private static final String ACT_UNSELECT_ALL = messages.getString("TablesSelector_ActUnselectAll");
    private final String[] tables;
    private final Collection<String> selected;

    TablesSelector(Collection<String> tables, Collection<String> selected) {
        this.tables = tables.toArray(new String[0]);
        this.selected = new HashSet<String>(selected);
    }

    public void show(Component invoker) {
        UI ui = new UI();
        ui.show(invoker);
    }

    protected abstract void selectionChanged(Collection<String> var1);

    private class UI {
        private JPanel panel;
        private SmallButton selectAll;
        private SmallButton unselectAll;

        UI() {
            this.populatePopup();
        }

        void show(Component invoker) {
            int resizeMode = 3;
            ProfilerPopup.createRelative(invoker, this.panel, 2, resizeMode).show();
        }

        private void populatePopup() {
            JPanel content = new JPanel(new BorderLayout());
            JLabel hint = new JLabel(SELECT_TABLES, 10);
            hint.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            content.add((Component)hint, "North");
            final SelectedTablesModel tablesModel = new SelectedTablesModel();
            final ProfilerTable tablesTable = new ProfilerTable(tablesModel, true, false, null);
            tablesTable.setColumnToolTips(new String[]{COLUMN_SELECTED_TOOLTIP, COLUMN_TABLE_TOOLTIP});
            tablesTable.setMainColumn(1);
            tablesTable.setFitWidthColumn(1);
            tablesTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
            tablesTable.setSortColumn(1);
            tablesTable.setFixedColumnSelection(0);
            tablesTable.setColumnRenderer(0, new CheckBoxRenderer());
            LabelRenderer projectRenderer = new LabelRenderer();
            tablesTable.setColumnRenderer(1, projectRenderer);
            int w = new JLabel((String)tablesTable.getColumnName((int)0)).getPreferredSize().width;
            tablesTable.setDefaultColumnWidth(0, w + 15);
            int h = tablesTable.getRowHeight() * 8;
            projectRenderer.setText("A LONGEST EXPECTED TABLE NAME A LONGEST EXPECTED TABLE NAME");
            Dimension prefSize = new Dimension(w + projectRenderer.getPreferredSize().width, h += tablesTable.getTableHeader().getPreferredSize().height);
            tablesTable.setPreferredScrollableViewportSize(prefSize);
            ProfilerTableContainer tableContainer = new ProfilerTableContainer(tablesTable, true, null);
            JPanel tableContent = new JPanel(new BorderLayout());
            tableContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            tableContent.add((Component)tableContainer, "Center");
            content.add((Component)tableContent, "Center");
            FilteringToolbar controls = new FilteringToolbar(FILTER_TABLES){

                @Override
                protected void filterChanged() {
                    if (this.isAll()) {
                        tablesTable.setRowFilter(null);
                    } else {
                        tablesTable.setRowFilter(new RowFilter(){

                            public boolean include(RowFilter.Entry entry) {
                                return this.passes(entry.getStringValue(1));
                            }
                        });
                    }
                }
            };
            controls.add(Box.createHorizontalStrut(2));
            ((JToolBar)controls).addSeparator();
            controls.add(Box.createHorizontalStrut(3));
            this.selectAll = new SmallButton(" " + ACT_SELECT_ALL + " "){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TablesSelector.this.selected.clear();
                            tablesModel.fireTableDataChanged();
                            UI.this.doSelectionChanged(TablesSelector.this.selected);
                        }
                    });
                }
            };
            controls.add(this.selectAll);
            this.unselectAll = new SmallButton(" " + ACT_UNSELECT_ALL + " "){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TablesSelector.this.selected.clear();
                            TablesSelector.this.selected.addAll(Arrays.asList(TablesSelector.this.tables));
                            tablesModel.fireTableDataChanged();
                            UI.this.doSelectionChanged(TablesSelector.this.selected);
                        }
                    });
                }
            };
            controls.add(this.unselectAll);
            content.add((Component)controls, "South");
            this.panel = content;
            this.updateSelectionButtons();
        }

        private void updateSelectionButtons() {
            this.selectAll.setEnabled(!TablesSelector.this.selected.isEmpty());
            this.unselectAll.setEnabled(TablesSelector.this.selected.size() < TablesSelector.this.tables.length);
        }

        private void doSelectionChanged(Collection<String> selected) {
            this.updateSelectionButtons();
            TablesSelector.this.selectionChanged(selected);
        }

        private class SelectedTablesModel
        extends AbstractTableModel {
            private SelectedTablesModel() {
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return COLUMN_SELECTED;
                }
                if (columnIndex == 1) {
                    return COLUMN_TABLE;
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                if (columnIndex == 1) {
                    return Lookup.Provider.class;
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return TablesSelector.this.tables.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return !TablesSelector.this.selected.contains(TablesSelector.this.tables[rowIndex]);
                }
                if (columnIndex == 1) {
                    return TablesSelector.this.tables[rowIndex];
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (Boolean.TRUE.equals(aValue)) {
                    if (TablesSelector.this.selected.remove(TablesSelector.this.tables[rowIndex])) {
                        UI.this.doSelectionChanged(TablesSelector.this.selected);
                    }
                } else if (TablesSelector.this.selected.add(TablesSelector.this.tables[rowIndex])) {
                    UI.this.doSelectionChanged(TablesSelector.this.selected);
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }
        }
    }
}

