/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;
import org.graalvm.visualvm.lib.jfluid.results.DataManagerListener;
import org.graalvm.visualvm.lib.jfluid.results.memory.ClassHistoryDataManager;
import org.graalvm.visualvm.lib.ui.graphs.GraphsUI;

public final class ClassHistoryModels {
    private final ClassHistoryDataManager dataManager;
    private final Timeline timeline;
    private final SynchronousXYItemsModel allocationsItemsModel;
    private final SynchronousXYItemsModel livenessItemsModel;

    public ClassHistoryModels(ClassHistoryDataManager dataManager) {
        this.dataManager = dataManager;
        this.timeline = this.createTimeline();
        this.allocationsItemsModel = this.createAllocationsItemsModel(this.timeline);
        this.livenessItemsModel = this.createLivenessItemsModel(this.timeline);
        dataManager.addDataListener(new DataManagerListener(){

            public void dataChanged() {
                ClassHistoryModels.this.dataChangedImpl();
            }

            public void dataReset() {
                ClassHistoryModels.this.dataResetImpl();
            }
        });
    }

    public ClassHistoryDataManager getDataManager() {
        return this.dataManager;
    }

    public SynchronousXYItemsModel allocationsItemsModel() {
        return this.allocationsItemsModel;
    }

    public SynchronousXYItemsModel livenessItemsModel() {
        return this.livenessItemsModel;
    }

    private void dataChangedImpl() {
        this.allocationsItemsModel.valuesAdded();
        this.livenessItemsModel.valuesAdded();
    }

    private void dataResetImpl() {
        this.allocationsItemsModel.valuesReset();
        this.livenessItemsModel.valuesReset();
    }

    private Timeline createTimeline() {
        return new Timeline(){

            public int getTimestampsCount() {
                return ClassHistoryModels.this.dataManager.getItemCount();
            }

            public long getTimestamp(int index) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.timeStamps[index];
            }
        };
    }

    private SynchronousXYItemsModel createAllocationsItemsModel(Timeline timeline) {
        SynchronousXYItem allocObjectsItem = new SynchronousXYItem(GraphsUI.A_ALLOC_OBJECTS_NAME, 0L){

            public long getYValue(int index) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.nTotalAllocObjects[index];
            }
        };
        allocObjectsItem.setInitialBounds(new LongRect(0L, 0L, 0L, 100L));
        SynchronousXYItem allocBytesItem = new SynchronousXYItem(GraphsUI.A_ALLOC_BYTES_NAME, 0L){

            public long getYValue(int index) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.totalAllocObjectsSize[index];
            }
        };
        allocBytesItem.setInitialBounds(new LongRect(0L, 0L, 0L, 102400L));
        SynchronousXYItemsModel model = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{allocObjectsItem, allocBytesItem});
        return model;
    }

    private SynchronousXYItemsModel createLivenessItemsModel(Timeline timeline) {
        SynchronousXYItem liveObjectsItem = new SynchronousXYItem(GraphsUI.L_LIVE_OBJECTS_NAME, 0L){

            public long getYValue(int index) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.nTrackedLiveObjects[index];
            }
        };
        liveObjectsItem.setInitialBounds(new LongRect(0L, 0L, 0L, 100L));
        SynchronousXYItem liveBytesItem = new SynchronousXYItem(GraphsUI.L_LIVE_BYTES_NAME, 0L){

            public long getYValue(int index) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.trackedLiveObjectsSize[index];
            }
        };
        liveBytesItem.setInitialBounds(new LongRect(0L, 0L, 0L, 102400L));
        SynchronousXYItem allocObjectsItem = new SynchronousXYItem(GraphsUI.A_ALLOC_OBJECTS_NAME, 0L){

            public long getYValue(int index) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.nTotalAllocObjects[index];
            }
        };
        allocObjectsItem.setInitialBounds(new LongRect(0L, 0L, 0L, 100L));
        SynchronousXYItemsModel model = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{liveObjectsItem, liveBytesItem, allocObjectsItem});
        return model;
    }
}

