/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.memory.ClassHistoryDataManager;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryCCTProvider;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.ui.LiveResultsPanel;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.memory.AllocResultsPanel;
import org.graalvm.visualvm.lib.ui.memory.ClassHistoryActionsHandler;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;

public class LiveAllocResultsPanel
extends AllocResultsPanel
implements LiveResultsPanel,
ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_LiveShowStackTracesPopupItemName");
    private static final String LOG_CLASS_HISTORY = messages.getString("LiveResultsPanel_LogClassHistory");
    protected TargetAppRunner runner;
    private ClassHistoryActionsHandler historyActionsHandler;
    private ClassHistoryDataManager classHistoryManager;
    private JMenuItem popupShowSource;
    private JMenuItem popupShowStacks;
    private JMenuItem startHisto;
    private JPopupMenu memoryResPopupMenu;
    private ProfilingSessionStatus status;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveAllocResultsPanel(TargetAppRunner runner, MemoryResUserActionsHandler actionsHandler, ClassHistoryActionsHandler historyActionsHandler, ClassHistoryDataManager classHistoryManager) {
        super(actionsHandler);
        this.status = runner.getProfilerClient().getStatus();
        this.runner = runner;
        this.historyActionsHandler = historyActionsHandler;
        this.classHistoryManager = classHistoryManager;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    @Override
    public String getViewName() {
        return "memory-allocations-live";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (e.getSource() == this.popupShowSource && this.popupShowSource != null) {
            this.showSourceForClass(this.selectedClassId);
        } else if (e.getSource() == this.startHisto) {
            String selectedClassName = StringUtils.userFormClassName((String)this.getClassName(this.selectedClassId));
            this.historyActionsHandler.showClassHistory(this.selectedClassId, selectedClassName);
        }
    }

    public void fetchResultsFromTargetApp() throws ClientUtils.TargetAppOrVMTerminated {
        MemoryCCTProvider oacgb = this.runner.getProfilerClient().getMemoryCCTProvider();
        if (oacgb == null) {
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        this.totalAllocObjectsSize = oacgb.getAllocObjectNumbers();
        this.nTotalAllocObjects = this.runner.getProfilerClient().getAllocatedObjectsCountResults();
        this.nTrackedItems = this.status.getNInstrClasses();
        if (this.nTrackedItems > this.nTotalAllocObjects.length) {
            this.nTrackedItems = this.nTotalAllocObjects.length;
        }
        if (this.nTrackedItems > this.totalAllocObjectsSize.length) {
            this.nTrackedItems = this.totalAllocObjectsSize.length;
        }
        this.maxValue = 0L;
        this.nTotalBytes = 0L;
        this.nTotalClasses = 0L;
        for (int i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.totalAllocObjectsSize[i]) {
                this.maxValue = this.totalAllocObjectsSize[i];
            }
            this.nTotalBytes += this.totalAllocObjectsSize[i];
            this.nTotalClasses += (long)this.nTotalAllocObjects[i];
        }
        if (this.classHistoryManager.isTrackingClass()) {
            this.classHistoryManager.processData(this.nTotalAllocObjects, this.totalAllocObjectsSize);
        }
        this.initDataUponResultsFetch();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = false;
            this.memoryResPopupMenu.setVisible(false);
        }
    }

    @Override
    public boolean hasView() {
        return this.resTable != null;
    }

    @Override
    public boolean supports(int instrumentataionType) {
        return instrumentataionType == 5;
    }

    @Override
    public void updateLiveResults() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        try {
            if (this.runner.getProfilingSessionStatus().targetAppRunning) {
                this.reset();
                this.fetchResultsFromTargetApp();
            }
            this.prepareResults();
            if (selectedRowString != null) {
                this.resTable.selectRowByContents(selectedRowString, 0, false);
            }
            if (this.resTable != null && this.resTable.isFocusOwner()) {
                this.resTable.requestFocusInWindow();
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)e.getMessage());
            ProfilerLogger.log((String)e.getMessage());
        }
        this.updateResultsInProgress = false;
    }

    @Override
    protected String getClassName(int classId) {
        return this.status.getClassNames()[classId];
    }

    @Override
    protected String[] getClassNames() {
        return this.status.getClassNames();
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (GoToSource.isAvailable()) {
                Font boldfont = this.memoryResPopupMenu.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setFont(boldfont);
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowSource);
                this.popupShowSource.addActionListener(this);
                this.memoryResPopupMenu.addSeparator();
            }
            if (this.runner.getProfilerEngineSettings().getAllocStackTraceLimit() != 0) {
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
                this.memoryResPopupMenu.addSeparator();
            }
            this.startHisto = new JMenuItem();
            this.startHisto.setText(LOG_CLASS_HISTORY);
            this.memoryResPopupMenu.add(this.startHisto);
            this.startHisto.addActionListener(this);
            this.memoryResPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (LiveAllocResultsPanel.this.updateResultsPending) {
                                LiveAllocResultsPanel.this.updateLiveResults();
                                LiveAllocResultsPanel.this.updateResultsPending = false;
                            }
                        }
                    });
                }
            });
        }
        boolean jvmAlive = this.status.targetAppRunning;
        if (this.popupShowStacks != null) {
            this.popupShowStacks.setEnabled(jvmAlive);
        }
        this.startHisto.setEnabled(jvmAlive);
        return this.memoryResPopupMenu;
    }

    public void exportData(int typeOfFile, ExportDataDumper eDD, String viewName) {
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        switch (typeOfFile) {
            case 1: {
                this.exportCSV(",", eDD);
                break;
            }
            case 2: {
                this.exportCSV(";", eDD);
                break;
            }
            case 3: {
                this.exportXML(eDD, viewName);
                break;
            }
            case 4: {
                this.exportHTML(eDD, viewName);
            }
        }
        this.percentFormat.setMinimumFractionDigits(0);
        this.percentFormat.setMaximumFractionDigits(1);
    }

    private void exportHTML(ExportDataDumper eDD, String viewName) {
        int i;
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append("<th>").append(this.columnNames[i]).append("</th>");
        }
        result.append("</tr>");
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[i]) + "</td>");
            result.append("<td align=\"right\">").append(this.percentFormat.format((double)this.totalAllocObjectsSize[i] / (double)this.nTotalBytes)).append("</td>");
            result.append("<td align=\"right\">").append(this.totalAllocObjectsSize[i]).append(" B</td>");
            result.append("<td align=\"right\">").append(this.nTotalAllocObjects[i]).append("</td></tr>");
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper eDD, String viewName) {
        int i;
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\">" + newline);
        result.append("<TableData NumRows=\"").append(this.nTrackedItems).append("\" NumColumns=\"4\">").append(newline).append("<TableHeader>");
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append("  <TableColumn><![CDATA[").append(this.columnNames[i]).append("]]></TableColumn>").append(newline);
        }
        result.append("</TableHeader>");
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("  <TableRow>" + newline + "   <TableColumn><![CDATA[" + this.sortedClassNames[i] + "]]></TableColumn>" + newline);
            result.append("   <TableColumn><![CDATA[").append(this.percentFormat.format((double)this.totalAllocObjectsSize[i] / (double)this.nTotalBytes)).append("]]></TableColumn>").append(newline);
            result.append("   <TableColumn><![CDATA[").append(this.totalAllocObjectsSize[i]).append("]]></TableColumn>").append(newline);
            result.append("   <TableColumn><![CDATA[").append(this.nTotalAllocObjects[i]).append("]]></TableColumn>").append(newline).append("  </TableRow>").append(newline);
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TableData>" + newline + "</ExportedView>"));
    }

    private void exportCSV(String separator, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append(quote).append(this.columnNames[i]).append(quote).append(separator);
        }
        result.deleteCharAt(result.length() - 1);
        result.append(newLine);
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer();
            result.append(quote).append(this.sortedClassNames[i]).append(quote).append(separator);
            result.append(quote).append(this.percentFormat.format((double)this.totalAllocObjectsSize[i] / (double)this.nTotalBytes)).append(quote).append(separator);
            result.append(quote).append(this.totalAllocObjectsSize[i]).append(quote).append(separator);
            result.append(quote).append(this.nTotalAllocObjects[i]).append(quote).append(newLine);
            eDD.dumpData((CharSequence)result);
        }
        eDD.close();
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

