/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.api.java;

import java.util.Set;
import org.graalvm.visualvm.lib.profiler.api.ProfilerSource;
import org.graalvm.visualvm.lib.profiler.api.java.SourceClassInfo;
import org.graalvm.visualvm.lib.profiler.api.java.SourceMethodInfo;
import org.graalvm.visualvm.lib.profiler.spi.java.AbstractJavaProfilerSource;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class JavaProfilerSource
extends ProfilerSource {
    private final AbstractJavaProfilerSource impl;

    public static JavaProfilerSource createFrom(FileObject fo) {
        if (fo == null || !fo.isValid()) {
            return null;
        }
        Lookup lkp = MimeLookup.getLookup((String)fo.getMIMEType());
        AbstractJavaProfilerSource impl = (AbstractJavaProfilerSource)lkp.lookup(AbstractJavaProfilerSource.class);
        if (impl == null && fo.isData() && fo.hasExt("java")) {
            impl = (AbstractJavaProfilerSource)Lookup.getDefault().lookup(AbstractJavaProfilerSource.class);
        }
        if (impl == null) {
            return null;
        }
        return new JavaProfilerSource(fo, impl);
    }

    private JavaProfilerSource(FileObject file, AbstractJavaProfilerSource impl) {
        super(file);
        this.impl = impl;
    }

    public boolean isTest() {
        return this.impl.isTest(this.getFile());
    }

    public boolean isApplet() {
        return this.impl.isApplet(this.getFile());
    }

    public SourceClassInfo getTopLevelClass() {
        return this.impl.getTopLevelClass(this.getFile());
    }

    public Set<SourceClassInfo> getClasses() {
        return this.impl.getClasses(this.getFile());
    }

    public Set<SourceClassInfo> getMainClasses() {
        return this.impl.getMainClasses(this.getFile());
    }

    public Set<SourceMethodInfo> getConstructors() {
        return this.impl.getConstructors(this.getFile());
    }

    public SourceClassInfo getEnclosingClass(int position) {
        return this.impl.getEnclosingClass(this.getFile(), position);
    }

    public SourceMethodInfo getEnclosingMethod(int position) {
        return this.impl.getEnclosingMethod(this.getFile(), position);
    }

    public boolean isInstanceOf(String[] classNames, boolean allRequired) {
        return this.impl.isInstanceOf(this.getFile(), classNames, allRequired);
    }

    public boolean isInstanceOf(String className) {
        return this.impl.isInstanceOf(this.getFile(), className);
    }

    public boolean hasAnnotation(String[] annotationNames, boolean allRequired) {
        return this.impl.hasAnnotation(this.getFile(), annotationNames, allRequired);
    }

    public boolean hasAnnotation(String annotation) {
        return this.impl.hasAnnotation(this.getFile(), annotation);
    }

    public boolean isOffsetValid(int offset) {
        return this.impl.isOffsetValid(this.getFile(), offset);
    }

    public SourceMethodInfo resolveMethodAtPosition(int position) {
        return this.impl.resolveMethodAtPosition(this.getFile(), position);
    }

    public SourceClassInfo resolveClassAtPosition(int position, boolean resolveField) {
        return this.impl.resolveClassAtPosition(this.getFile(), position, resolveField);
    }

    @Override
    public boolean isRunnable() {
        return this.isApplet() || this.isTest() || !this.getMainClasses().isEmpty();
    }
}

