/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.attach.providers;

import java.io.IOException;
import org.graalvm.visualvm.lib.profiler.attach.providers.Bundle;
import org.graalvm.visualvm.lib.profiler.attach.spi.AbstractRemotePackExporter;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Lookup;

public final class RemotePackExporter {
    private AbstractRemotePackExporter impl = (AbstractRemotePackExporter)Lookup.getDefault().lookup(AbstractRemotePackExporter.class);

    public static RemotePackExporter getInstance() {
        return Singleton.INSTANCE;
    }

    private RemotePackExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(String exportPath, String hostOS, String jvm) throws IOException {
        if (this.impl == null) {
            throw new IOException();
        }
        ProgressHandle ph = ProgressHandle.createHandle((String)Bundle.RemotePackExporter_GeneratingRemotePack(this.impl.getRemotePackPath(exportPath, hostOS)));
        ph.setInitialDelay(500);
        ph.start();
        try {
            String string = this.impl.export(exportPath, hostOS, jvm);
            return string;
        }
        finally {
            ph.finish();
        }
    }

    public void export(String hostOS, String jvm) throws IOException {
        this.export(null, hostOS, jvm);
    }

    public boolean isAvailable() {
        return this.impl != null;
    }

    private static final class Singleton {
        private static final RemotePackExporter INSTANCE = new RemotePackExporter();

        private Singleton() {
        }
    }
}

