/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.gtk;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import org.netbeans.swing.plaf.util.UIUtils;

final class ThemeValue
implements UIDefaults.ActiveValue {
    private final Object fallback;
    private final Region aRegion;
    private ColorType aColorType = null;
    private boolean darken = false;
    private Object value = null;
    private static Boolean functioning = null;
    private int ct = 0;
    private static boolean log = Boolean.getBoolean("themeValue.log");
    private static JButton dummyButton = null;
    private static Class<?> gtkColorType = null;
    private static Method synthStyle_getColorForState = null;
    private static Method synthStyle_getFontForState = null;
    static ColorType LIGHT = null;
    static ColorType DARK = null;
    static ColorType BLACK = null;
    static ColorType WHITE = null;
    static ColorType MID = null;
    private static HashSet<ThemeValue> instances = null;

    public ThemeValue(Region region, ColorType colorType, Object object) {
        this.fallback = object;
        this.aRegion = region;
        this.aColorType = colorType;
        ThemeValue.register(this);
    }

    public ThemeValue(Region region, ColorType colorType, Object object, boolean bl) {
        this.fallback = object;
        this.aRegion = region;
        this.aColorType = colorType;
        this.darken = bl;
        ThemeValue.register(this);
    }

    public ThemeValue(Region region, Font font) {
        this.fallback = font;
        this.aRegion = region;
        ThemeValue.register(this);
    }

    @Override
    public Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            if (!ThemeValue.functioning()) {
                this.value = this.fallback;
            } else if (this.fallback instanceof Font) {
                Font font = this.getFont();
                if (this.ct++ < 4) {
                    return font;
                }
                this.value = font;
            } else {
                this.value = this.getColor();
            }
        }
        return this.value != null ? this.value : this.fallback;
    }

    void clear() {
        this.value = null;
    }

    public Font getFont() {
        block4: {
            SynthStyle synthStyle = ThemeValue.getSynthStyle(this.aRegion);
            if (Boolean.TRUE.equals(functioning)) {
                try {
                    Font font = (Font)synthStyle_getFontForState.invoke((Object)synthStyle, ThemeValue.getSynthContext());
                    if (font == null) {
                        font = (Font)this.fallback;
                    }
                    return font;
                }
                catch (Exception exception) {
                    functioning = Boolean.FALSE;
                    if (!log) break block4;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public Color getColor() {
        block5: {
            SynthStyle synthStyle = ThemeValue.getSynthStyle(this.aRegion);
            if (Boolean.TRUE.equals(functioning)) {
                try {
                    Color color = (Color)synthStyle_getColorForState.invoke((Object)synthStyle, ThemeValue.getSynthContext(), this.aColorType);
                    if (color == null) {
                        color = (Color)this.fallback;
                    }
                    if (this.darken) {
                        color = color.darker();
                    }
                    return color;
                }
                catch (Exception exception) {
                    functioning = Boolean.FALSE;
                    if (!log) break block5;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean functioning() {
        if (functioning == null) {
            ThemeValue.checkFunctioning();
        }
        return functioning;
    }

    private static void checkFunctioning() {
        functioning = Boolean.FALSE;
        try {
            gtkColorType = UIUtils.classForName("com.sun.java.swing.plaf.gtk.GTKColorType");
            synthStyle_getColorForState = SynthStyle.class.getDeclaredMethod("getColorForState", SynthContext.class, ColorType.class);
            synthStyle_getColorForState.setAccessible(true);
            synthStyle_getFontForState = SynthStyle.class.getDeclaredMethod("getFontForState", SynthContext.class);
            synthStyle_getFontForState.setAccessible(true);
            LIGHT = (ColorType)ThemeValue.valueOfField(gtkColorType, "LIGHT");
            DARK = (ColorType)ThemeValue.valueOfField(gtkColorType, "DARK");
            MID = (ColorType)ThemeValue.valueOfField(gtkColorType, "MID");
            BLACK = (ColorType)ThemeValue.valueOfField(gtkColorType, "BLACK");
            WHITE = (ColorType)ThemeValue.valueOfField(gtkColorType, "WHITE");
            functioning = Boolean.TRUE;
        }
        catch (Exception exception) {
            System.err.println("Cannot initialize GTK colors - using hardcoded defaults: " + exception);
            if (log) {
                exception.printStackTrace();
            }
            return;
        }
    }

    private static JButton getDummyButton() {
        Object object;
        if (dummyButton == null) {
            dummyButton = new JButton();
            object = new CellRendererPane();
            ((Container)object).add(dummyButton);
        }
        object = dummyButton.getModel();
        return dummyButton;
    }

    private static SynthContext getSynthContext() {
        try {
            JButton jButton = ThemeValue.getDummyButton();
            ButtonUI buttonUI = jButton.getUI();
            if (buttonUI instanceof SynthUI) {
                return ((SynthUI)((Object)buttonUI)).getContext(jButton);
            }
            throw new IllegalStateException("I don't have a SynthButtonUI to play with");
        }
        catch (Exception exception) {
            functioning = Boolean.FALSE;
            if (log) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private static SynthStyle getSynthStyle(Region region) {
        return SynthLookAndFeel.getStyle(ThemeValue.getDummyButton(), region);
    }

    private static Object valueOfField(Class clazz, String string) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        return field.get(null);
    }

    private static synchronized void register(ThemeValue themeValue) {
        if (instances == null) {
            instances = new HashSet();
            ThemeValue.registerPcl();
        }
        instances.add(themeValue);
    }

    private static void registerPcl() {
        Listener listener = new Listener();
        UIManager.addPropertyChangeListener(listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Gtk/FontName", listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Xft/DPI", listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Net/ThemeName", listener);
    }

    static {
        ThemeValue.functioning();
    }

    private static class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof UIManager && "lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                String string = UIManager.getLookAndFeel().getClass().getName();
                if (string.indexOf("gtk") < 0) {
                    UIManager.removePropertyChangeListener(this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Gtk/FontName", this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Xft/DPI", this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Net/ThemeName", this);
                }
            } else {
                for (ThemeValue themeValue : instances) {
                    themeValue.clear();
                }
            }
        }
    }
}

