/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.utils;

import java.util.Comparator;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;

public abstract class TimeRecord {
    public static Comparator<TimeRecord> COMPARATOR = new Comparator<TimeRecord>(){

        @Override
        public int compare(TimeRecord r1, TimeRecord r2) {
            return Long.compare(r1.time, r2.time);
        }
    };
    public final long time;

    public TimeRecord(JFREvent event, JFRModel model) throws JFRPropertyNotAvailableException {
        this.time = TimeRecord.getTime(event, model);
    }

    public static long getTime(JFREvent event, JFRModel model) throws JFRPropertyNotAvailableException {
        return ValuesConverter.instantToRelativeNanos(event.getInstant("eventTime"), model);
    }

    public int hashCode() {
        return Long.hashCode(this.time);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TimeRecord) {
            return this.time == ((TimeRecord)o).time;
        }
        return false;
    }
}

