/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.memory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.MemoryMXBean;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.HeapHistogram;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.jfluid.results.memory.SampledMemoryResultsSnapshot;
import org.graalvm.visualvm.sampler.truffle.AbstractSamplerSupport;
import org.graalvm.visualvm.sampler.truffle.memory.MemoryHistogramProvider;
import org.graalvm.visualvm.sampler.truffle.memory.MemoryView;
import org.openide.util.NbBundle;

public abstract class MemorySamplerSupport
extends AbstractSamplerSupport {
    private final Application application;
    private final MemoryHistogramProvider histogramProvider;
    private final MemoryMXBean memoryBean;
    private final HeapDumper heapDumper;
    private final SnapshotDumper snapshotDumper;
    private Timer processor;
    private final AtomicBoolean updateIsRunning;
    private javax.swing.Timer heapTimer;
    private AbstractSamplerSupport.Refresher heapRefresher;
    private MemoryView heapView;
    private DataViewComponent.DetailsView[] detailsViews;

    public MemorySamplerSupport(Application application, MemoryHistogramProvider mhp, MemoryMXBean memoryBean, SnapshotDumper snapshotDumper, HeapDumper heapDumper) {
        this.application = application;
        this.histogramProvider = mhp;
        this.memoryBean = memoryBean;
        this.heapDumper = heapDumper;
        this.snapshotDumper = snapshotDumper;
        this.updateIsRunning = new AtomicBoolean();
    }

    @Override
    public DataViewComponent.DetailsView[] getDetailsView() {
        if (this.detailsViews == null) {
            this.initialize();
            this.detailsViews = this.createViews();
        }
        this.heapView.initSession();
        return (DataViewComponent.DetailsView[])this.detailsViews.clone();
    }

    @Override
    public boolean startSampling(ProfilingSettings settings, int samplingRate, int refreshRate) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MemorySamplerSupport.this.heapView != null) {
                    MemorySamplerSupport.this.heapView.starting();
                }
            }
        });
        this.heapRefresher.setRefreshRate(samplingRate);
        if (this.heapView != null) {
            this.doRefreshImpl(this.heapTimer, this.heapView);
        }
        return true;
    }

    @Override
    public synchronized void stopSampling() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MemorySamplerSupport.this.heapView != null) {
                    MemorySamplerSupport.this.heapView.stopping();
                }
            }
        });
        this.heapTimer.stop();
        if (this.heapView != null) {
            this.doRefreshImplImpl(this.snapshotDumper.lastHistogram, this.heapView);
        }
    }

    @Override
    public synchronized void terminate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MemorySamplerSupport.this.heapView != null) {
                    MemorySamplerSupport.this.heapView.terminated();
                }
            }
        });
    }

    private String initialize() {
        int defaultRefresh = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        this.processor = this.getTimer();
        this.heapTimer = new javax.swing.Timer(defaultRefresh, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySamplerSupport.this.heapRefresher.refresh();
            }
        });
        this.heapRefresher = new AbstractSamplerSupport.Refresher(){

            @Override
            public final boolean checkRefresh() {
                if (!MemorySamplerSupport.this.heapTimer.isRunning()) {
                    return false;
                }
                return MemorySamplerSupport.this.heapView.isShowing();
            }

            @Override
            public final void doRefresh() {
                if (MemorySamplerSupport.this.heapView.isShowing()) {
                    MemorySamplerSupport.this.doRefreshImpl(MemorySamplerSupport.this.heapTimer, new MemoryView[]{MemorySamplerSupport.this.heapView});
                }
            }

            @Override
            public final void setRefreshRate(int refreshRate) {
                MemorySamplerSupport.this.heapTimer.setDelay(refreshRate);
                MemorySamplerSupport.this.heapTimer.setInitialDelay(refreshRate);
                MemorySamplerSupport.this.heapTimer.restart();
            }

            @Override
            public final int getRefreshRate() {
                return MemorySamplerSupport.this.heapTimer.getDelay();
            }
        };
        return null;
    }

    private DataViewComponent.DetailsView[] createViews() {
        int detailIndex = 0;
        int detailsCount = 1;
        DataViewComponent.DetailsView[] details = new DataViewComponent.DetailsView[detailsCount];
        this.heapView = new MemoryView(this.application, this.heapRefresher, this.memoryBean, this.snapshotDumper, this.heapDumper);
        details[detailIndex++] = new DataViewComponent.DetailsView(NbBundle.getMessage(MemorySamplerSupport.class, (String)"LBL_Heap_histogram"), null, 10, (JComponent)this.heapView, null);
        return details;
    }

    private void doRefreshImpl(final javax.swing.Timer timer, final MemoryView ... views) {
        if (!timer.isRunning() || views.length == 1 && views[0].isPaused()) {
            return;
        }
        if (!this.updateIsRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processor.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (!timer.isRunning()) {
                            return;
                        }
                        MemorySamplerSupport.this.doRefreshImplImpl(MemorySamplerSupport.this.takeHeapHistogram(), views);
                    }
                    catch (Exception e) {
                        if (MemorySamplerSupport.this.application.getState() == 1) {
                            e.printStackTrace();
                        }
                        MemorySamplerSupport.this.terminate();
                    }
                    finally {
                        MemorySamplerSupport.this.updateIsRunning.set(false);
                    }
                }
            }, 0L);
        }
        catch (Exception e) {
            this.terminate();
        }
    }

    private TruffleHeapHistogram takeHeapHistogram() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Map[] histo = this.histogramProvider.heapHistogram();
        return new TruffleHeapHistogram(histo);
    }

    private void doRefreshImplImpl(final TruffleHeapHistogram heapHistogram, final MemoryView ... views) {
        if (heapHistogram != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemorySamplerSupport.this.snapshotDumper.lastHistogram = heapHistogram;
                    for (MemoryView view : views) {
                        view.refresh(heapHistogram);
                    }
                }
            });
        }
    }

    static class TruffleClassInfo
    extends HeapHistogram.ClassInfo {
        String name;
        long allocatedInstances;
        long liveInstances;
        long bytes;
        long liveBytes;

        TruffleClassInfo() {
        }

        private TruffleClassInfo(Map<String, Object> info) {
            this.name = info.get("language") + "." + info.get("name");
            this.allocatedInstances = (Long)info.get("allocatedInstancesCount");
            this.bytes = (Long)info.get("bytes");
            this.liveInstances = (Long)info.get("liveInstancesCount");
            this.liveBytes = (Long)info.get("liveBytes");
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.liveInstances;
        }

        public long getBytes() {
            return this.liveBytes;
        }

        public long getAllocatedInstances() {
            return this.allocatedInstances;
        }

        public long getAllocatedBytes() {
            return this.bytes;
        }
    }

    static class TruffleHeapHistogram
    extends HeapHistogram {
        private long totalInstances;
        private long totalBytes;
        private long totalAllocInstances;
        private long totalAllocBytes;
        private final long time = System.currentTimeMillis();
        private final Set<TruffleClassInfo> classes;

        private TruffleHeapHistogram(Map<String, Object>[] heap) {
            this.classes = new HashSet<TruffleClassInfo>(heap.length);
            for (Map<String, Object> classInfo : heap) {
                TruffleClassInfo info = new TruffleClassInfo(classInfo);
                this.totalInstances += info.getInstancesCount();
                this.totalBytes += info.getBytes();
                this.totalAllocInstances += info.getAllocatedInstances();
                this.totalAllocBytes += info.getAllocatedBytes();
                this.classes.add(info);
            }
        }

        public Date getTime() {
            return new Date(this.time);
        }

        public long getTotalInstances() {
            return this.totalInstances;
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        public long getTotalAllocInstances() {
            return this.totalAllocInstances;
        }

        public long getTotalAllocBytes() {
            return this.totalAllocBytes;
        }

        public Set<HeapHistogram.ClassInfo> getHeapHistogram() {
            return Collections.unmodifiableSet(this.classes);
        }

        public long getTotalHeapInstances() {
            return this.totalInstances;
        }

        public long getTotalHeapBytes() {
            return this.totalBytes;
        }

        public Set<HeapHistogram.ClassInfo> getPermGenHistogram() {
            return null;
        }

        public long getTotalPerGenInstances() {
            return 0L;
        }

        public long getTotalPermGenHeapBytes() {
            return 0L;
        }
    }

    public static abstract class SnapshotDumper {
        private volatile TruffleHeapHistogram lastHistogram;

        public abstract void takeSnapshot(boolean var1);

        public SampledMemoryResultsSnapshot createSnapshot(long time) {
            TruffleHeapHistogram histogram = this.lastHistogram;
            if (histogram != null) {
                ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                DataOutputStream dos = new DataOutputStream(output);
                try {
                    SampledMemoryResultsSnapshot result = new SampledMemoryResultsSnapshot();
                    Set classes = histogram.getHeapHistogram();
                    dos.writeInt(1);
                    dos.writeLong(histogram.getTime().getTime());
                    dos.writeLong(time);
                    dos.writeInt(classes.size());
                    for (HeapHistogram.ClassInfo info : classes) {
                        dos.writeUTF(info.getName());
                        dos.writeLong(info.getBytes());
                    }
                    dos.writeBoolean(false);
                    dos.writeInt(classes.size());
                    for (HeapHistogram.ClassInfo info : classes) {
                        dos.writeInt((int)info.getInstancesCount());
                    }
                    dos.close();
                    result.readFromStream(new DataInputStream(new ByteArrayInputStream(output.toByteArray())));
                    return result;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }
    }

    public static abstract class HeapDumper {
        public abstract void takeHeapDump(boolean var1);
    }
}

