/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.snapshot;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshot;
import org.openide.util.NbBundle;

final class ProfilerSnapshotView
extends SnapshotView {
    private ProfilerSnapshot loadedSnapshot = null;

    ProfilerSnapshotView(ProfilerSnapshot snapshot) {
        this(snapshot, DataSourceDescriptorFactory.getDescriptor((DataSource)snapshot));
    }

    private ProfilerSnapshotView(ProfilerSnapshot snapshot, DataSourceDescriptor descriptor) {
        super((Snapshot)snapshot, descriptor.getName(), descriptor.getIcon(), 0x7FFFFFFE);
        this.loadedSnapshot = snapshot;
    }

    protected void removed() {
        this.loadedSnapshot.closeComponent();
        this.loadedSnapshot = null;
    }

    protected DataViewComponent createComponent() {
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport().getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    private class MasterViewSupport
    extends JPanel {
        private MasterViewSupport() {
        }

        public DataViewComponent.MasterView getMasterView() {
            JComponent srw = ProfilerSnapshotView.this.loadedSnapshot.getUIComponent();
            return new DataViewComponent.MasterView(NbBundle.getMessage(ProfilerSnapshotView.class, (String)"DESCR_Profiler_Snapshot"), null, srw);
        }
    }
}

