/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.charts.xy;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.charts.ChartConfigurationListener;
import org.graalvm.visualvm.lib.charts.PaintersModel;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYChart;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.NbBundle;

class SimpleXYChart
extends SynchronousXYChart {
    private static final Icon ZOOM_IN_ICON = Icons.getIcon((String)"GeneralIcons.ZoomIn");
    private static final Icon ZOOM_OUT_ICON = Icons.getIcon((String)"GeneralIcons.ZoomOut");
    private static final Icon FIXED_SCALE_ICON = Icons.getIcon((String)"GeneralIcons.Zoom");
    private static final Icon SCALE_TO_FIT_ICON = Icons.getIcon((String)"GeneralIcons.ScaleToFit");
    private JScrollBar scroller;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private ToggleViewAction toggleViewAction;
    private ChartConfigurationListener listener;

    SimpleXYChart(SynchronousXYItemsModel itemsModel, PaintersModel paintersModel) {
        super(itemsModel, paintersModel);
        this.setMousePanningEnabled(false);
    }

    void setZoomingEnabled(boolean zooming) {
        if (this.isZoomingEnabled() == zooming) {
            return;
        }
        if (zooming) {
            this.enableZooming();
        } else {
            this.disableZooming();
        }
    }

    boolean isZoomingEnabled() {
        return this.listener != null;
    }

    JScrollBar getScroller() {
        return this.scroller;
    }

    Action[] getActions() {
        Action[] actionArray;
        if (this.toggleViewAction == null) {
            actionArray = new Action[]{};
        } else {
            Action[] actionArray2 = new Action[3];
            actionArray2[0] = this.toggleViewAction;
            actionArray2[1] = this.zoomInAction;
            actionArray = actionArray2;
            actionArray2[2] = this.zoomOutAction;
        }
        return actionArray;
    }

    private void enableZooming() {
        this.scroller = new JScrollBar(0);
        this.attachHorizontalScrollBar(this.scroller);
        this.zoomInAction = new ZoomInAction();
        this.zoomOutAction = new ZoomOutAction();
        this.toggleViewAction = new ToggleViewAction();
        this.listener = new VisibleBoundsListener();
        this.addConfigurationListener(this.listener);
    }

    private void disableZooming() {
        this.removeConfigurationListener(this.listener);
        this.listener = null;
        this.detachHorizontalScrollBar();
        this.scroller = null;
        this.zoomInAction = null;
        this.zoomOutAction = null;
        this.toggleViewAction = null;
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        public void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
            if (SimpleXYChart.this.zoomInAction != null) {
                SimpleXYChart.this.zoomInAction.updateAction();
            }
            if (SimpleXYChart.this.zoomOutAction != null) {
                SimpleXYChart.this.zoomOutAction.updateAction();
            }
        }

        public void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
            if (SimpleXYChart.this.zoomInAction != null) {
                SimpleXYChart.this.zoomInAction.updateAction();
            }
            if (SimpleXYChart.this.zoomOutAction != null) {
                SimpleXYChart.this.zoomOutAction.updateAction();
            }
        }
    }

    private class ToggleViewAction
    extends AbstractAction {
        private long origOffsetX = -1L;
        private double origScaleX = -1.0;

        ToggleViewAction() {
            this.updateAction();
            SimpleXYChart.this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        ToggleViewAction.this.actionPerformed(null);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean fitsWidth = SimpleXYChart.this.fitsWidth();
            if (!fitsWidth) {
                this.origOffsetX = SimpleXYChart.this.getOffsetX();
                if (SimpleXYChart.this.tracksDataWidth() && this.origOffsetX == SimpleXYChart.this.getMaxOffsetX()) {
                    this.origOffsetX = Long.MAX_VALUE;
                }
                this.origScaleX = SimpleXYChart.this.getScaleX();
            }
            SimpleXYChart.this.setFitsWidth(!fitsWidth);
            if (fitsWidth && this.origOffsetX != -1L && this.origScaleX != -1.0) {
                SimpleXYChart.this.setScale(this.origScaleX, SimpleXYChart.this.getScaleY());
                SimpleXYChart.this.setOffset(this.origOffsetX, SimpleXYChart.this.getOffsetY());
            }
            this.updateAction();
            if (SimpleXYChart.this.zoomInAction != null) {
                SimpleXYChart.this.zoomInAction.updateAction();
            }
            if (SimpleXYChart.this.zoomOutAction != null) {
                SimpleXYChart.this.zoomOutAction.updateAction();
            }
            SimpleXYChart.this.repaintDirty();
        }

        private void updateAction() {
            boolean fitsWidth = SimpleXYChart.this.fitsWidth();
            Icon icon = fitsWidth ? FIXED_SCALE_ICON : SCALE_TO_FIT_ICON;
            String name = fitsWidth ? NbBundle.getMessage(SimpleXYChart.class, (String)"SimpleXYChart_FixedScaleString") : NbBundle.getMessage(SimpleXYChart.class, (String)"SimpleXYChart_ScaleToFitString");
            this.putValue("ShortDescription", name);
            this.putValue("SmallIcon", icon);
            if (SimpleXYChart.this.scroller != null) {
                SimpleXYChart.this.scroller.setVisible(!fitsWidth);
            }
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        ZoomOutAction() {
            this.putValue("ShortDescription", NbBundle.getMessage(SimpleXYChart.class, (String)"SimpleXYChart_ZoomOutString"));
            this.putValue("SmallIcon", ZOOM_OUT_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean followsWidth = SimpleXYChart.this.currentlyFollowingDataWidth();
            SimpleXYChart.this.zoom(SimpleXYChart.this.getWidth() / 2, SimpleXYChart.this.getHeight() / 2, 0.5);
            if (followsWidth) {
                SimpleXYChart.this.setOffset(SimpleXYChart.this.getMaxOffsetX(), SimpleXYChart.this.getOffsetY());
            }
            SimpleXYChart.this.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)SimpleXYChart.this.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 1 && !SimpleXYChart.this.fitsWidth());
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        ZoomInAction() {
            this.putValue("ShortDescription", NbBundle.getMessage(SimpleXYChart.class, (String)"SimpleXYChart_ZoomInString"));
            this.putValue("SmallIcon", ZOOM_IN_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean followsWidth = SimpleXYChart.this.currentlyFollowingDataWidth();
            SimpleXYChart.this.zoom(SimpleXYChart.this.getWidth() / 2, SimpleXYChart.this.getHeight() / 2, 2.0);
            if (followsWidth) {
                SimpleXYChart.this.setOffset(SimpleXYChart.this.getMaxOffsetX(), SimpleXYChart.this.getOffsetY());
            }
            SimpleXYChart.this.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)SimpleXYChart.this.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 1 && !SimpleXYChart.this.fitsWidth());
        }
    }
}

