/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.oql;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.OQLEngine;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.OQLException;
import org.graalvm.visualvm.lib.profiler.oql.spi.OQLEditorImpl;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.NoCaret;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class OQLEditorComponent
extends JPanel {
    private static final String VALIDITY_PROPERTY = "document#valid";
    private volatile boolean lexervalid;
    private volatile boolean parserValid;
    private volatile boolean oldValidity;
    private final OQLEngine engine;
    private JEditorPane queryEditor;
    private JScrollBar verticalScroller;
    private Color lastBgColor;
    private Caret lastCaret;
    private boolean changed;

    public OQLEditorComponent(OQLEngine engine) {
        this.engine = engine;
        this.init();
    }

    public void setScript(String script) {
        this.queryEditor.setText(script);
        this.clearChanged();
        try {
            this.queryEditor.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.scrollRectToVisible(new Rectangle());
    }

    public String getScript() {
        return this.queryEditor.getText();
    }

    protected void validityChanged(boolean valid) {
    }

    final void clearChanged() {
        this.changed = false;
    }

    public final boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.verticalScroller != null) {
            this.updateScroller(this.verticalScroller);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.queryEditor != null) {
            this.queryEditor.setBackground(bg);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.queryEditor != null) {
            this.queryEditor.setOpaque(isOpaque);
        }
    }

    @Override
    public void requestFocus() {
        if (this.queryEditor != null) {
            this.queryEditor.requestFocus();
        }
    }

    public void setEditable(boolean b) {
        if (this.queryEditor.isEditable() == b) {
            return;
        }
        this.queryEditor.setEditable(b);
        if (b) {
            if (this.lastBgColor != null) {
                this.queryEditor.setBackground(this.lastBgColor);
            }
            if (this.lastCaret != null) {
                this.queryEditor.setCaret(this.lastCaret);
            }
        } else {
            this.lastBgColor = this.queryEditor.getBackground();
            this.lastCaret = this.queryEditor.getCaret();
            Color disabledBackground = UIUtils.isGTKLookAndFeel() ? UIManager.getLookAndFeel().getDefaults().getColor("desktop") : UIManager.getColor("TextField.disabledBackground");
            this.queryEditor.setBackground(disabledBackground);
            this.queryEditor.setCaret((Caret)new NoCaret());
        }
    }

    public boolean isEditable() {
        return this.queryEditor.isEditable();
    }

    public void clearScrollBorders() {
        Component c;
        if (this.getComponentCount() > 0 && (c = this.getComponent(0)) instanceof JScrollPane) {
            ((JScrollPane)c).setBorder(BorderFactory.createEmptyBorder());
            ((JScrollPane)c).setViewportBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void init() {
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        OQLEditorImpl impl = (OQLEditorImpl)Lookup.getDefault().lookup(OQLEditorImpl.class);
        if (impl != null) {
            this.queryEditor = impl.getEditorPane();
            this.queryEditor.getDocument().putProperty(OQLEngine.class, this.engine);
            this.queryEditor.getDocument().putProperty(OQLEditorImpl.ValidationCallback.class, new OQLEditorImpl.ValidationCallback(){

                public void callback(boolean lexingResult) {
                    OQLEditorComponent.this.lexervalid = lexingResult;
                    OQLEditorComponent.this.validateScript();
                }
            });
            this.queryEditor.getCaret().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        Rectangle edit;
                        Rectangle rectangle = edit = OQLEditorComponent.this.queryEditor == null ? null : OQLEditorComponent.this.queryEditor.getUI().modelToView(OQLEditorComponent.this.queryEditor, OQLEditorComponent.this.queryEditor.getCaretPosition());
                        if (edit != null) {
                            OQLEditorComponent.this.queryEditor.scrollRectToVisible(edit);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            Element root = this.queryEditor.getDocument().getDefaultRootElement();
            String family = StyleConstants.getFontFamily(root.getAttributes());
            this.queryEditor.setFont(new Font(family, 0, new JEditorPane().getFont().getSize()));
        } else {
            final DocumentListener listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    OQLEditorComponent.this.validateScript();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    OQLEditorComponent.this.validateScript();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    OQLEditorComponent.this.validateScript();
                }
            };
            final DocumentListener editHandler = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleEdit();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleEdit();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleEdit();
                }

                private void handleEdit() {
                    OQLEditorComponent.this.changed = true;
                }
            };
            this.queryEditor = new JEditorPane(){

                @Override
                protected EditorKit createDefaultEditorKit() {
                    return new OQLEditorKit();
                }

                @Override
                public void setText(String text) {
                    Document doc = this.getDocument();
                    if (doc != null) {
                        doc.removeDocumentListener(listener);
                        doc.removeDocumentListener(editHandler);
                    }
                    this.setDocument(this.getEditorKit().createDefaultDocument());
                    doc = this.getDocument();
                    if (doc != null) {
                        doc.addDocumentListener(listener);
                    }
                    super.setText(text);
                    if (doc != null) {
                        doc.addDocumentListener(editHandler);
                    }
                }
            };
            this.queryEditor.setFont(Font.decode("Monospaced " + this.queryEditor.getFont().getSize()));
            this.lexervalid = true;
        }
        this.queryEditor.setText("");
        this.queryEditor.setOpaque(this.isOpaque());
        this.queryEditor.setBackground(this.getBackground());
        this.queryEditor.putClientProperty("nb.ctrltab.popupswitcher.disable", Boolean.TRUE);
        int rowSize = this.queryEditor.getFontMetrics(this.queryEditor.getFont()).getHeight();
        final JScrollPane editorScroll = new JScrollPane(this.queryEditor, 22, 30);
        editorScroll.getHorizontalScrollBar().setUnitIncrement(rowSize);
        this.verticalScroller = editorScroll.getVerticalScrollBar();
        this.verticalScroller.setUnitIncrement(rowSize);
        this.verticalScroller.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OQLEditorComponent.this.updateScroller(OQLEditorComponent.this.verticalScroller);
            }
        });
        JTextField tf = new JTextField(" 999 ");
        tf.setBorder(BorderFactory.createEmptyBorder());
        tf.setMargin(new Insets(0, 0, 0, 0));
        tf.setFont(this.queryEditor.getFont());
        final int w = tf.getPreferredSize().width;
        JEditorPane rows = new JEditorPane(){
            {
                this.setEditorKit(OQLEditorComponent.this.queryEditor.getEditorKit());
                this.setFont(OQLEditorComponent.this.queryEditor.getFont());
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = new Dimension(w, 0);
                int refHeight = ((OQLEditorComponent)OQLEditorComponent.this).queryEditor.getPreferredSize().height;
                int viewHeight = editorScroll.getViewport().getExtentSize().height;
                dim.height = Math.max(refHeight, viewHeight);
                return dim;
            }

            @Override
            public void setBackground(Color c) {
                super.setBackground(!UISupport.isDarkResultsBackground() ? new Color(245, 245, 245) : new Color(55, 55, 55));
            }
        };
        rows.setCaret(new FollowingCaret(this.queryEditor));
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < 1000; ++i) {
            if (i < 1000) {
                sb.append(" ");
            }
            if (i < 100) {
                sb.append(" ");
            }
            if (i < 10) {
                sb.append(" ");
            }
            sb.append(Integer.toString(i) + " \n");
        }
        rows.setText(sb.toString());
        rows.setEditable(false);
        rows.setEnabled(false);
        Insets margin = this.queryEditor.getMargin();
        if (margin == null) {
            margin = new Insets(0, 0, 0, 0);
        }
        rows.setMargin(new Insets(margin.top, 0, margin.bottom, 0));
        Border border = this.queryEditor.getBorder();
        if (border != null) {
            margin = border.getBorderInsets(this.queryEditor);
            if (margin == null) {
                margin = new Insets(0, 0, 0, 0);
            }
            rows.setBorder(BorderFactory.createEmptyBorder(margin.top, -1, margin.bottom, 0));
        }
        editorScroll.setRowHeaderView(rows);
        this.setLayout(new BorderLayout());
        this.add((Component)editorScroll, "Center");
    }

    private void updateScroller(JScrollBar scroll) {
        scroll.setEnabled(this.isEnabled() && scroll.getVisibleAmount() < scroll.getMaximum());
    }

    private void validateScript() {
        if (this.engine == null) {
            return;
        }
        if (this.lexervalid || !this.parserValid) {
            try {
                this.engine.parseQuery(this.getScript());
                this.parserValid = true;
            }
            catch (OQLException e) {
                StatusDisplayer.getDefault().setStatusText(e.getLocalizedMessage());
                this.parserValid = false;
            }
        }
        this.firePropertyChange(VALIDITY_PROPERTY, this.oldValidity, this.lexervalid && this.parserValid);
        this.oldValidity = this.lexervalid && this.parserValid;
        this.validityChanged(this.oldValidity);
    }

    private static class FollowingCaret
    implements Caret {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private int dot;

        FollowingCaret(final JTextComponent tc) {
            tc.getCaret().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.setDot(FollowingCaret.followedPosition(tc));
                }
            });
            this.setDot(FollowingCaret.followedPosition(tc));
        }

        private static int followedPosition(JTextComponent tc) {
            Element root = tc.getDocument().getDefaultRootElement();
            return root.getElementIndex(tc.getCaretPosition()) * 6;
        }

        @Override
        public void install(JTextComponent c) {
        }

        @Override
        public void deinstall(JTextComponent c) {
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void setVisible(boolean v) {
        }

        @Override
        public boolean isSelectionVisible() {
            return false;
        }

        @Override
        public void setSelectionVisible(boolean v) {
        }

        @Override
        public void setMagicCaretPosition(Point p) {
        }

        @Override
        public Point getMagicCaretPosition() {
            return new Point(0, 0);
        }

        @Override
        public void setBlinkRate(int rate) {
        }

        @Override
        public int getBlinkRate() {
            return 1;
        }

        @Override
        public int getDot() {
            return this.dot;
        }

        @Override
        public int getMark() {
            return this.dot;
        }

        @Override
        public void moveDot(int dot) {
        }

        @Override
        public void setDot(int dot) {
            this.dot = dot;
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : this.listeners) {
                l.stateChanged(e);
            }
        }
    }

    private static class OQLEditorKit
    extends DefaultEditorKit {
        private static final ViewFactory FACTORY = new ViewFactory(){

            @Override
            public View create(Element elem) {
                return new PlainView(elem);
            }
        };

        private OQLEditorKit() {
        }

        @Override
        public String getContentType() {
            return "text/x-oql";
        }

        @Override
        public ViewFactory getViewFactory() {
            return FACTORY;
        }
    }
}

