/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.impl;

class HelperScriptFactory {
    private static final JsHelperFunction[] JS_HELPER_FUNCTIONS_NS = new JsHelperFunction[]{new JsHelperFunction("isPlainHostName", new String[]{"host"}, Boolean.class), new JsHelperFunction("dnsDomainIs", new String[]{"host", "domain"}, Boolean.class), new JsHelperFunction("localHostOrDomainIs", new String[]{"host", "hostdom"}, Boolean.class), new JsHelperFunction("isResolvable", new String[]{"host"}, Boolean.class), new JsHelperFunction("isInNet", new String[]{"host", "pattern", "mask"}, Boolean.class), new JsHelperFunction("dnsResolve", new String[]{"host"}, String.class), new JsHelperFunction("myIpAddress", new String[0], String.class), new JsHelperFunction("dnsDomainLevels", new String[]{"host"}, Integer.class), new JsHelperFunction("shExpMatch", new String[]{"str", "shexp"}, Boolean.class), new JsHelperFunction("weekdayRange", new String[]{"wd1", "wd2", "gmt"}, Boolean.class), new JsHelperFunction("dateRange", new String[]{"day1", "month1", "year1", "day2", "month2", "year2", "gmt"}, Boolean.class), new JsHelperFunction("timeRange", new String[]{"hour1", "min1", "sec1", "hour2", "min2", "sec2", "gmt"}, Boolean.class)};
    private static final JsHelperFunction[] JS_HELPER_FUNCTIONS_MS = new JsHelperFunction[]{new JsHelperFunction("isResolvableEx", new String[]{"host"}, Boolean.class), new JsHelperFunction("isInNetEx", new String[]{"host", "ipPrefix"}, Boolean.class), new JsHelperFunction("dnsResolveEx", new String[]{"host"}, String.class), new JsHelperFunction("myIpAddressEx", new String[0], String.class), new JsHelperFunction("sortIpAddressList", new String[]{"ipAddressList"}, String.class), new JsHelperFunction("getClientVersion", new String[0], String.class)};
    private static final JsHelperFunction[] JS_HELPER_FUNCTIONS_DEBUG = new JsHelperFunction[]{new JsHelperFunction("alert", new String[]{"txt"}, Void.class)};

    private HelperScriptFactory() {
    }

    public static String getPacHelperSource() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append("(function(self) {\n");
        HelperScriptFactory.addFunctionDecls(stringBuilder, JS_HELPER_FUNCTIONS_NS);
        HelperScriptFactory.addFunctionDecls(stringBuilder, JS_HELPER_FUNCTIONS_MS);
        HelperScriptFactory.addFunctionDecls(stringBuilder, JS_HELPER_FUNCTIONS_DEBUG);
        stringBuilder.append("})\n");
        return stringBuilder.toString();
    }

    private static void addFunctionDecls(StringBuilder stringBuilder, JsHelperFunction[] jsHelperFunctionArray) {
        for (JsHelperFunction jsHelperFunction : jsHelperFunctionArray) {
            stringBuilder.append("this['");
            stringBuilder.append(jsHelperFunction.functionName);
            stringBuilder.append("'] = function(");
            HelperScriptFactory.addArgList(stringBuilder, jsHelperFunction.argList);
            stringBuilder.append(") {\n");
            stringBuilder.append("    return ");
            boolean bl = false;
            if (Number.class.isAssignableFrom(jsHelperFunction.getClass())) {
                bl = true;
                stringBuilder.append("Number(");
            }
            if (jsHelperFunction.returnType == String.class) {
                bl = true;
                stringBuilder.append("String(");
            }
            stringBuilder.append("self.");
            stringBuilder.append(jsHelperFunction.functionName);
            stringBuilder.append('(');
            HelperScriptFactory.addArgList(stringBuilder, jsHelperFunction.argList);
            stringBuilder.append(')');
            if (bl) {
                stringBuilder.append(')');
            }
            stringBuilder.append(";\n");
            stringBuilder.append("}\n\n");
        }
    }

    private static void addArgList(StringBuilder stringBuilder, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append(", ");
            }
        }
    }

    private static class JsHelperFunction {
        String functionName;
        String[] argList;
        Class returnType;

        public JsHelperFunction(String string, String[] stringArray, Class clazz) {
            this.functionName = string;
            this.argList = stringArray;
            this.returnType = clazz;
        }
    }
}

