/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.JfrThread;
import org.openjdk.jmc.flightrecorder.internal.util.CanonicalConstantMap;

final class OSThreadFactory
implements IPoolFactory<IMCThread> {
    private final CanonicalConstantMap<JfrThread> threadsMap;

    OSThreadFactory(CanonicalConstantMap<JfrThread> threadsMap) {
        this.threadsMap = threadsMap;
    }

    @Override
    public IMCThread createObject(long identifier, Object o) {
        int osThreadId = (int)identifier;
        if (osThreadId == 0) {
            return null;
        }
        String name = (String)o;
        JfrThread thread = this.threadsMap.canonicalize(new JfrThread(osThreadId));
        thread.addName(name);
        return thread;
    }

    @Override
    public ContentType<IMCThread> getContentType() {
        return UnitLookup.THREAD;
    }
}

