/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.util.Objects;
import org.netbeans.core.startup.layers.NbinstURLMapper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class NbinstURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        return new NbinstURLConnection(uRL);
    }

    @Override
    protected InetAddress getHostAddress(URL uRL) {
        return null;
    }

    @Override
    protected int hashCode(URL uRL) {
        String string;
        int n = 0;
        String string2 = uRL.getHost();
        if (string2 != null) {
            n += string2.toLowerCase().hashCode();
        }
        if ((string = uRL.getFile()) != null) {
            n += string.hashCode();
        }
        return n;
    }

    @Override
    protected boolean sameFile(URL uRL, URL uRL2) {
        if (!(uRL.getProtocol() == uRL2.getProtocol() || uRL.getProtocol() != null && uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()))) {
            return false;
        }
        if (!Objects.equals(uRL.getFile(), uRL2.getFile())) {
            return false;
        }
        return this.hostsEqual(uRL, uRL2);
    }

    @Override
    protected boolean hostsEqual(URL uRL, URL uRL2) {
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if (string != null && string2 != null) {
            return string.equalsIgnoreCase(string2);
        }
        return string == null && string2 == null;
    }

    private static class NbinstURLConnection
    extends URLConnection {
        private File f;
        private InputStream iStream;

        public NbinstURLConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() throws IOException {
            if (this.f == null) {
                this.f = NbinstURLMapper.decodeURL(this.url);
                if (this.f == null) {
                    throw new FileNotFoundException("Cannot find: " + this.url);
                }
            }
            if (!this.f.isFile()) {
                throw new UnknownServiceException();
            }
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
                return (int)this.f.length();
            }
            catch (IOException iOException) {
                return -1;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.iStream == null) {
                this.iStream = new FileInputStream(this.f);
            }
            return this.iStream;
        }

        @Override
        public String getHeaderField(String string) {
            if ("content-type".equals(string)) {
                try {
                    this.connect();
                    FileObject fileObject = FileUtil.toFileObject((File)this.f);
                    if (fileObject != null) {
                        return fileObject.getMIMEType();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return super.getHeaderField(string);
        }
    }
}

