/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

class NodeRenderDataProvider
implements CheckRenderDataProvider {
    private Outline table;
    private boolean showIcons = true;
    private Icon emptyIcon;

    public NodeRenderDataProvider(Outline outline) {
        this.table = outline;
    }

    public Color getBackground(Object object) {
        return null;
    }

    public String getDisplayName(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        String string = node.getHtmlDisplayName();
        if (null == string) {
            string = node.getDisplayName();
        }
        return string;
    }

    public Color getForeground(Object object) {
        return null;
    }

    public void setShowIcons(boolean bl) {
        this.showIcons = bl;
        if (!bl && this.emptyIcon == null) {
            this.emptyIcon = new EmptyIcon();
        }
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public Icon getIcon(Object object) {
        Object object2;
        if (!this.showIcons) {
            return this.emptyIcon;
        }
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        boolean bl = false;
        if (object instanceof TreeNode) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (object2 = (TreeNode)object; object2 != null; object2 = object2.getParent()) {
                arrayList.add(object2);
            }
            Collections.reverse(arrayList);
            TreePath treePath = new TreePath(arrayList.toArray());
            AbstractLayoutCache abstractLayoutCache = this.table.getLayoutCache();
            bl = abstractLayoutCache.isExpanded(treePath);
        }
        object2 = null;
        object2 = bl ? node.getOpenedIcon(1) : node.getIcon(1);
        return ImageUtilities.image2Icon((Image)object2);
    }

    public String getTooltipText(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        return node.getShortDescription();
    }

    public boolean isHtmlDisplayName(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        return null != node.getHtmlDisplayName();
    }

    private CheckableNode getCheckCookie(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        return (CheckableNode)node.getLookup().lookup(CheckableNode.class);
    }

    public boolean isCheckable(Object object) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        return checkableNode != null && checkableNode.isCheckable();
    }

    public boolean isCheckEnabled(Object object) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        return checkableNode != null && checkableNode.isCheckEnabled();
    }

    public Boolean isSelected(Object object) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        if (checkableNode != null) {
            return checkableNode.isSelected();
        }
        return null;
    }

    public void setSelected(Object object, Boolean bl) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        if (checkableNode != null) {
            checkableNode.setSelected(bl);
        }
    }

    private static final class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }
}

