/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDragSupport;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;

final class OutlineViewDragSupport
extends ExplorerDragSupport {
    protected OutlineView view;

    public OutlineViewDragSupport(OutlineView outlineView, JComponent jComponent) {
        this.view = outlineView;
        this.comp = jComponent;
    }

    @Override
    public int getAllowedDragActions() {
        return this.view.getAllowedDragActions();
    }

    @Override
    int getAllowedDropActions() {
        return this.view.getAllowedDropActions();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        super.dragGestureRecognized(dragGestureEvent);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        Node[] nodeArray = this.exDnD.getDraggedNodes();
        super.dragDropEnd(dragSourceDropEvent);
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
            this.exDnD.setDnDActive(false);
        }
        try {
            ExplorerManager.Provider provider;
            if (nodeArray != null && (provider = (ExplorerManager.Provider)((Object)SwingUtilities.getAncestorOfClass(ExplorerManager.Provider.class, this.view))) != null) {
                provider.getExplorerManager().setSelectedNodes(nodeArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    Node[] obtainNodes(DragGestureEvent dragGestureEvent) {
        int[] nArray = this.view.getOutline().getSelectedRows();
        ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            Node node = this.view.getNodeFromRow(nArray[i]);
            if (node == null) continue;
            arrayList.add(node);
        }
        Node[] nodeArray = arrayList.toArray(new Node[0]);
        return nodeArray;
    }
}

