/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.util.Exceptions;

public class InstallUnitWizardModel
extends OperationWizardModel {
    private InstallSupport.Installer installer = null;
    private OperationWizardModel.OperationType doOperation;
    private static Set<String> approvedLicences = new HashSet<String>();
    private OperationContainer<InstallSupport> updateContainer = null;
    private OperationContainer<OperationSupport> customContainer = Containers.forCustomInstall();
    private PluginManagerUI manager;
    private boolean allLicensesTouched = false;

    public InstallUnitWizardModel(OperationWizardModel.OperationType operationType, OperationContainer<InstallSupport> operationContainer) {
        this.doOperation = operationType;
        this.updateContainer = operationContainer;
    }

    public InstallUnitWizardModel(OperationWizardModel.OperationType operationType) {
        this.doOperation = operationType;
        assert (this.getBaseContainer() != null) : "The base container for operation " + (Object)((Object)operationType) + " must exist!";
        this.updateContainer = this.getBaseContainer();
    }

    @Override
    public OperationWizardModel.OperationType getOperation() {
        return this.doOperation;
    }

    public OperationContainer<InstallSupport> getBaseContainer() {
        OperationContainer<InstallSupport> operationContainer = this.getBaseContainerImpl();
        assert (operationContainer.getSupport() != null || operationContainer.listAll().isEmpty()) : "Non empty container[list: " + operationContainer.listAll() + ", invalid: " + operationContainer.listInvalid() + "]: but support is " + operationContainer.getSupport();
        return operationContainer;
    }

    OperationContainer<InstallSupport> getInstallContainer() {
        return this.getBaseContainer();
    }

    private OperationContainer<InstallSupport> getBaseContainerImpl() {
        if (this.updateContainer != null) {
            return this.updateContainer;
        }
        OperationContainer<InstallSupport> operationContainer = null;
        switch (this.getOperation()) {
            case INSTALL: {
                operationContainer = Containers.forAvailable();
                break;
            }
            case UPDATE: {
                operationContainer = Containers.forUpdate();
                break;
            }
            case LOCAL_DOWNLOAD: {
                OperationContainer<InstallSupport> operationContainer2 = Containers.forUpdateNbms();
                OperationContainer<InstallSupport> operationContainer3 = Containers.forAvailableNbms();
                if (operationContainer2.listAll().isEmpty()) {
                    operationContainer = operationContainer3;
                } else {
                    operationContainer = operationContainer2;
                    for (OperationContainer.OperationInfo operationInfo : operationContainer3.listAll()) {
                        operationContainer.add(operationInfo.getUpdateElement());
                    }
                    assert (operationContainer3.listInvalid().isEmpty()) : "Containers.forAvailableNbms().listInvalid() should be empty but " + operationContainer3.listInvalid();
                    operationContainer3.removeAll();
                }
                this.updateContainer = operationContainer;
            }
        }
        return operationContainer;
    }

    @Override
    public OperationContainer<OperationSupport> getCustomHandledContainer() {
        return this.customContainer;
    }

    public boolean allLicensesApproved() {
        boolean bl = true;
        for (UpdateElement updateElement : this.getAllUpdateElements()) {
            String string;
            if (OperationWizardModel.OperationType.UPDATE.equals((Object)this.getOperation()) && Utilities.isLicenseIdApproved(updateElement.getLicenseId()) || (string = updateElement.getLicence()) == null || approvedLicences.contains(string)) continue;
            bl = false;
            break;
        }
        this.allLicensesTouched = true;
        return bl;
    }

    public boolean allLicensesTouched() {
        return this.allLicensesTouched;
    }

    public void addApprovedLicenses(Collection<String> collection) {
        approvedLicences.addAll(collection);
        this.allLicensesTouched = false;
    }

    public void setInstaller(InstallSupport.Installer installer) {
        this.installer = installer;
    }

    public InstallSupport.Installer getInstaller() {
        return this.installer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCleanup(boolean bl) throws OperationException {
        try {
            if (bl) {
                InstallSupport installSupport;
                if (this.getBaseContainerImpl() != null && this.getBaseContainerImpl().getSupport() != null) {
                    ((InstallSupport)this.getBaseContainerImpl().getSupport()).doCancel();
                }
                if (OperationWizardModel.OperationType.LOCAL_DOWNLOAD == this.getOperation()) {
                    InstallSupport installSupport2;
                    installSupport = (InstallSupport)Containers.forAvailableNbms().getSupport();
                    if (installSupport != null) {
                        installSupport.doCancel();
                    }
                    if ((installSupport2 = (InstallSupport)Containers.forUpdateNbms().getSupport()) != null) {
                        installSupport2.doCancel();
                    }
                    Containers.forAvailableNbms().removeAll();
                    Containers.forUpdateNbms().removeAll();
                } else {
                    installSupport = (InstallSupport)this.getBaseContainer().getSupport();
                    if (installSupport != null) {
                        installSupport.doCancel();
                    }
                }
                installSupport = (OperationSupport)this.getCustomHandledContainer().getSupport();
                if (installSupport != null) {
                    installSupport.doCancel();
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        finally {
            super.doCleanup(false);
        }
    }

    public PluginManagerUI getPluginManager() {
        return this.manager;
    }

    public void setPluginManager(PluginManagerUI pluginManagerUI) {
        this.manager = pluginManagerUI;
    }
}

