/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.autoupdate.ui.wizards.CustomHandleStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LicenseApprovalStep;
import org.openide.WizardDescriptor;

abstract class InstallableIteratorBase
implements WizardDescriptor.Iterator<WizardDescriptor> {
    protected final List<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
    protected final InstallUnitWizardModel installModel;
    protected int index;
    private WizardDescriptor.Panel<WizardDescriptor> licenseApprovalStep = null;
    private WizardDescriptor.Panel<WizardDescriptor> customHandleStep = null;
    private WizardDescriptor.Panel<WizardDescriptor> installStep = null;
    private boolean isCompact = false;
    private boolean clearLazyUnits = false;
    private final boolean allowRunInBackground;
    private final boolean runInBackground;

    public InstallableIteratorBase(InstallUnitWizardModel installUnitWizardModel) {
        this(installUnitWizardModel, false);
    }

    public InstallableIteratorBase(InstallUnitWizardModel installUnitWizardModel, boolean bl) {
        this(installUnitWizardModel, bl, true, true);
    }

    public InstallableIteratorBase(InstallUnitWizardModel installUnitWizardModel, boolean bl, boolean bl2) {
        this(installUnitWizardModel, bl, bl2, false);
    }

    public InstallableIteratorBase(InstallUnitWizardModel installUnitWizardModel, boolean bl, boolean bl2, boolean bl3) {
        this.installModel = installUnitWizardModel;
        this.clearLazyUnits = bl;
        this.allowRunInBackground = bl2;
        this.runInBackground = bl3;
        this.index = 0;
    }

    public InstallUnitWizardModel getModel() {
        assert (this.installModel != null);
        return this.installModel;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        assert (this.panels != null);
        return this.panels.get(this.index);
    }

    public boolean hasNext() {
        this.compactPanels();
        return this.index < this.panels.size() - 1;
    }

    public void nextPanel() {
        this.compactPanels();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        this.compactPanels();
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public boolean hasPrevious() {
        this.compactPanels();
        return this.index > 0;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    protected void insertPanels(int n) {
        this.licenseApprovalStep = new LicenseApprovalStep(this.installModel);
        this.panels.add(n++, this.licenseApprovalStep);
        this.customHandleStep = new CustomHandleStep(this.installModel);
        this.panels.add(n++, this.customHandleStep);
        this.installStep = new InstallStep(this.installModel, this.clearLazyUnits, this.allowRunInBackground, this.runInBackground);
        this.panels.add(n++, this.installStep);
    }

    protected void removeInstallPanels() {
        this.panels.remove(this.licenseApprovalStep);
        this.panels.remove(this.installStep);
        this.panels.remove(this.customHandleStep);
    }

    protected void compactPanels() {
        if (this.isCompact) {
            return;
        }
        boolean bl = this.getModel().allLicensesTouched();
        if (bl && this.getModel().allLicensesApproved()) {
            this.panels.remove(this.licenseApprovalStep);
        }
        if (!this.getModel().hasCustomComponents()) {
            this.panels.remove(this.customHandleStep);
        }
        if (!this.getModel().hasStandardComponents()) {
            this.panels.remove(this.installStep);
        }
        this.isCompact = bl;
    }
}

