/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.MainClassApplicationTypeFactory;
import org.graalvm.visualvm.application.type.MavenApplicationType;

public class MavenApplicationTypeFactory
extends MainClassApplicationTypeFactory {
    private static final String MAIN_CLASS = "org.codehaus.classworlds.Launcher";
    private static final String MAIN_CLASS_1 = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final String PROP_1 = "-Dclassworlds.conf=";
    private static final String PROP_2 = "-Dmaven.home=";
    private static final String WRAPPER_MAIN_CLASS = "org.apache.maven.wrapper.MavenWrapperMain";

    @Override
    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        String args;
        if ((MAIN_CLASS.equals(mainClass) || MAIN_CLASS_1.equals(mainClass)) && (args = jvm.getJvmArgs()) != null && args.contains(PROP_1) && args.contains(PROP_2)) {
            return new MavenApplicationType(app, false);
        }
        if (WRAPPER_MAIN_CLASS.equals(mainClass)) {
            return new MavenApplicationType(app, true);
        }
        return null;
    }
}

