/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.quicksearch.Accessor;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class CommandEvaluator {
    static final String RECENT = "Recent";
    private static final String PROP_ENABLED_CATEGORIES = "enabledCategories";
    private static final Pattern COMMAND_PATTERN = Pattern.compile("(\\w+)(\\s+)(.+)");
    private static final RequestProcessor RP = new RequestProcessor("QuickSearch Command Evaluator", 10);
    private static Set<ProviderModel.Category> evalCats = CommandEvaluator.loadEvalCats();
    private static ProviderModel.Category temporaryCat = null;

    public static Task evaluate(String string, ResultsModel resultsModel) {
        ArrayList<CategoryResult> arrayList = new ArrayList<CategoryResult>();
        String[] stringArray = CommandEvaluator.parseCommand(string);
        SearchRequest searchRequest = Accessor.DEFAULT.createRequest(stringArray[1], null);
        ArrayList<RequestProcessor.Task> arrayList2 = new ArrayList<RequestProcessor.Task>();
        ArrayList<ProviderModel.Category> arrayList3 = new ArrayList<ProviderModel.Category>();
        boolean bl = CommandEvaluator.getProviderCategories(stringArray, arrayList3);
        for (ProviderModel.Category category : arrayList3) {
            CategoryResult categoryResult = new CategoryResult(category, bl);
            SearchResponse searchResponse = Accessor.DEFAULT.createResponse(categoryResult, searchRequest);
            for (SearchProvider searchProvider : category.getProviders()) {
                RequestProcessor.Task task = CommandEvaluator.runEvaluation(searchProvider, searchRequest, searchResponse, category);
                if (task == null) continue;
                arrayList2.add(task);
            }
            arrayList.add(categoryResult);
        }
        resultsModel.setContent(arrayList);
        return new Wait4AllTask(arrayList2);
    }

    private static Set<ProviderModel.Category> loadEvalCats() {
        final LinkedHashSet<ProviderModel.Category> linkedHashSet = new LinkedHashSet<ProviderModel.Category>(ProviderModel.getInstance().getCategories());
        RP.post(new Runnable(){

            @Override
            public void run() {
                String string = NbPreferences.forModule(CommandEvaluator.class).get(CommandEvaluator.PROP_ENABLED_CATEGORIES, null);
                if (string != null) {
                    LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
                    linkedHashSet2.addAll(Arrays.asList(string.split(":")));
                    Iterator iterator = linkedHashSet.iterator();
                    while (iterator.hasNext()) {
                        ProviderModel.Category category = (ProviderModel.Category)iterator.next();
                        if (linkedHashSet2.contains(category.getName()) || CommandEvaluator.RECENT.equals(category.getName())) continue;
                        iterator.remove();
                    }
                }
            }
        });
        return linkedHashSet;
    }

    private static void storeEvalCats() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder();
                for (ProviderModel.Category category : evalCats) {
                    if (CommandEvaluator.RECENT.equals(category.getName())) continue;
                    stringBuilder.append(category.getName());
                    stringBuilder.append(':');
                }
                NbPreferences.forModule(CommandEvaluator.class).put(CommandEvaluator.PROP_ENABLED_CATEGORIES, stringBuilder.toString());
            }
        });
    }

    public static Set<ProviderModel.Category> getEvalCats() {
        return evalCats;
    }

    public static void setEvalCats(Set<ProviderModel.Category> linkedHashSet) {
        evalCats = linkedHashSet == null ? new LinkedHashSet<ProviderModel.Category>(ProviderModel.getInstance().getCategories()) : linkedHashSet;
        CommandEvaluator.storeEvalCats();
    }

    public static void dropTemporaryCat() {
        temporaryCat = null;
    }

    public static void setTemporaryCat(ProviderModel.Category category) {
        temporaryCat = category;
    }

    public static boolean isTemporaryCatSpecified() {
        return temporaryCat != null;
    }

    public static ProviderModel.Category getTemporaryCat() {
        return temporaryCat;
    }

    private static String[] parseCommand(String string) {
        String[] stringArray = new String[2];
        Matcher matcher = COMMAND_PATTERN.matcher(string);
        if (matcher.matches()) {
            stringArray[0] = matcher.group(1);
            if (ProviderModel.getInstance().isKnownCommand(stringArray[0])) {
                stringArray[1] = matcher.group(3);
            } else {
                stringArray[0] = null;
                stringArray[1] = string;
            }
        } else {
            stringArray[1] = string;
        }
        return stringArray;
    }

    static boolean getProviderCategories(String[] stringArray, List<ProviderModel.Category> list) {
        List<ProviderModel.Category> list2 = ProviderModel.getInstance().getCategories();
        for (ProviderModel.Category category : list2) {
            if (!RECENT.equals(category.getName())) continue;
            list.add(category);
        }
        if (stringArray[1] == null || stringArray[1].trim().equals("")) {
            return false;
        }
        if (stringArray[0] != null) {
            for (ProviderModel.Category category : list2) {
                String string = category.getCommandPrefix();
                if (string == null || !string.equalsIgnoreCase(stringArray[0])) continue;
                list.add(category);
                return true;
            }
        }
        if (temporaryCat != null) {
            list.add(temporaryCat);
            return true;
        }
        for (ProviderModel.Category category : evalCats) {
            if (RECENT.equals(category.getName())) continue;
            list.add(category);
        }
        return list.size() < 3;
    }

    private static RequestProcessor.Task runEvaluation(final SearchProvider searchProvider, final SearchRequest searchRequest, final SearchResponse searchResponse, ProviderModel.Category category) {
        return RP.post(new Runnable(){

            @Override
            public void run() {
                searchProvider.evaluate(searchRequest, searchResponse);
            }
        });
    }

    private static class Wait4AllTask
    extends Task
    implements Runnable {
        private static final long TIMEOUT = 60000L;
        private final List<RequestProcessor.Task> tasks;

        private Wait4AllTask(List<RequestProcessor.Task> list) {
            this.tasks = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.notifyRunning();
                for (RequestProcessor.Task task : this.tasks) {
                    try {
                        task.waitFinished(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.notifyFinished();
            }
        }
    }
}

