/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.graalvm.visualvm.lib.jfluid.heap.CacheDirectory;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;

public class HeapFactory {
    public static Heap createHeap(File heapDump) throws FileNotFoundException, IOException {
        return HeapFactory.createHeap(heapDump, 0);
    }

    public static Heap createHeap(File heapDump, int segment) throws FileNotFoundException, IOException {
        File savedDump;
        CacheDirectory cacheDir = CacheDirectory.getHeapDumpCacheDirectory(heapDump, segment);
        if (!cacheDir.isTemporary() && (savedDump = cacheDir.getHeapDumpAuxFile()).exists() && savedDump.isFile() && savedDump.canRead()) {
            try {
                return HeapFactory.loadHeap(cacheDir);
            }
            catch (IOException ex) {
                System.err.println("Loading heap dump " + heapDump + " from cache failed.");
                ex.printStackTrace(System.err);
                cacheDir.deleteAllCachedFiles();
            }
        }
        return new HprofHeap(heapDump, segment, cacheDir);
    }

    public static int getTotalNumberOfSegments(Heap heap) throws IOException {
        if (heap instanceof HprofHeap) {
            return ((HprofHeap)heap).computeTotalNumberSegments();
        }
        return 1;
    }

    static Heap loadHeap(CacheDirectory cacheDir) throws FileNotFoundException, IOException {
        File savedDump = cacheDir.getHeapDumpAuxFile();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(savedDump), 65536);
        try (DataInputStream dis = new DataInputStream(is);){
            HprofHeap hprofHeap = new HprofHeap(dis, cacheDir);
            return hprofHeap;
        }
    }
}

