/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report;

import org.jacoco.report.ILanguageNames;
import org.objectweb.asm.Type;

public class JavaNames
implements ILanguageNames {
    public String getPackageName(String vmname) {
        if (vmname.length() == 0) {
            return "default";
        }
        return vmname.replace('/', '.');
    }

    private String getClassName(String vmname) {
        int pos = vmname.lastIndexOf(47);
        String name = pos == -1 ? vmname : vmname.substring(pos + 1);
        return name.replace('$', '.');
    }

    private boolean isAnonymous(String vmname) {
        int dollarPosition = vmname.lastIndexOf(36);
        if (dollarPosition == -1) {
            return false;
        }
        int internalPosition = dollarPosition + 1;
        if (internalPosition == vmname.length()) {
            return false;
        }
        char start = vmname.charAt(internalPosition);
        return !Character.isJavaIdentifierStart(start);
    }

    public String getClassName(String vmname, String vmsignature, String vmsuperclass, String[] vminterfaces) {
        String vmsupertype;
        if (this.isAnonymous(vmname) && (vmsupertype = vminterfaces != null && vminterfaces.length > 0 ? vminterfaces[0] : (vmsuperclass != null ? vmsuperclass : null)) != null) {
            StringBuilder builder = new StringBuilder();
            String vmenclosing = vmname.substring(0, vmname.lastIndexOf(36));
            builder.append(this.getClassName(vmenclosing)).append(".new ").append(this.getClassName(vmsupertype)).append("() {...}");
            return builder.toString();
        }
        return this.getClassName(vmname);
    }

    public String getQualifiedClassName(String vmname) {
        return vmname.replace('/', '.').replace('$', '.');
    }

    public String getMethodName(String vmclassname, String vmmethodname, String vmdesc, String vmsignature) {
        return this.getMethodName(vmclassname, vmmethodname, vmdesc, false);
    }

    public String getQualifiedMethodName(String vmclassname, String vmmethodname, String vmdesc, String vmsignature) {
        return this.getQualifiedClassName(vmclassname) + "." + this.getMethodName(vmclassname, vmmethodname, vmdesc, true);
    }

    private String getMethodName(String vmclassname, String vmmethodname, String vmdesc, boolean qualifiedParams) {
        if ("<clinit>".equals(vmmethodname)) {
            return "static {...}";
        }
        StringBuilder result = new StringBuilder();
        if ("<init>".equals(vmmethodname)) {
            if (this.isAnonymous(vmclassname)) {
                return "{...}";
            }
            result.append(this.getClassName(vmclassname));
        } else {
            result.append(vmmethodname);
        }
        result.append('(');
        Type[] arguments = Type.getArgumentTypes(vmdesc);
        boolean comma = false;
        for (Type arg : arguments) {
            if (comma) {
                result.append(", ");
            } else {
                comma = true;
            }
            if (qualifiedParams) {
                result.append(this.getQualifiedClassName(arg.getClassName()));
                continue;
            }
            result.append(this.getShortTypeName(arg));
        }
        result.append(')');
        return result.toString();
    }

    private String getShortTypeName(Type type) {
        String name = type.getClassName();
        int pos = name.lastIndexOf(46);
        String shortName = pos == -1 ? name : name.substring(pos + 1);
        return shortName.replace('$', '.');
    }
}

