/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.impl;

import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.layout.ObjectLayout;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\b\b\u0002\u0010#\u001a\u00020\rH\u0002J\u001a\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\b\b\u0002\u0010#\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/ultimate/hprof/impl/ShallowSizeStorage;", "", "dump", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "objectLayout", "Lcom/intellij/profiler/ultimate/layout/ObjectLayout;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;Lcom/intellij/profiler/ultimate/layout/ObjectLayout;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "headerSize", "", "arrayHeaderSize", "classInstancesShallowSize", "Lit/unimi/dsi/fastutil/longs/Long2IntOpenHashMap;", "classInstancesTotalSize", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "totalSize", "", "getTotalSize", "()J", "getSizeOfObjectInstance", "klass", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofClass;", "getSizeOfArrayInstance", "length", "classId", "calculateShallowSize", "", "calculateArraySize", "oneElementSize", "roundup", "value", "alignmentBytes", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nShallowSizeStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShallowSizeStorage.kt\ncom/intellij/profiler/ultimate/hprof/impl/ShallowSizeStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,79:1\n216#2,2:80\n*S KotlinDebug\n*F\n+ 1 ShallowSizeStorage.kt\ncom/intellij/profiler/ultimate/hprof/impl/ShallowSizeStorage\n*L\n29#1:80,2\n*E\n"})
public final class ShallowSizeStorage {
    @NotNull
    private final HprofDump dump;
    @NotNull
    private final ObjectLayout objectLayout;
    @Nullable
    private final ProgressIndicator indicator;
    private final int headerSize;
    private final int arrayHeaderSize;
    @NotNull
    private final Long2IntOpenHashMap classInstancesShallowSize;
    @NotNull
    private final Long2LongOpenHashMap classInstancesTotalSize;

    public ShallowSizeStorage(@NotNull HprofDump dump, @NotNull ObjectLayout objectLayout, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)objectLayout, (String)"objectLayout");
        this.dump = dump;
        this.objectLayout = objectLayout;
        this.indicator = indicator;
        this.headerSize = this.objectLayout.getMarkWordSize() + this.objectLayout.getKlassWordSize();
        this.arrayHeaderSize = ShallowSizeStorage.roundup$default(this, this.headerSize + this.objectLayout.getArrayHeaderSize(), 0, 2, null);
        this.classInstancesShallowSize = new Long2IntOpenHashMap();
        this.classInstancesTotalSize = new Long2LongOpenHashMap();
    }

    @Nullable
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public final long getTotalSize() {
        Collection collection = this.classInstancesTotalSize.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        return CollectionsKt.sumOfLong((Iterable)collection);
    }

    public final int getSizeOfObjectInstance(@NotNull HprofClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.classInstancesShallowSize.get(klass.getClassId());
    }

    public final long getSizeOfArrayInstance(@NotNull HprofClass klass, int length) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.calculateArraySize(klass, length);
    }

    public final long getTotalSize(long classId) {
        return this.classInstancesTotalSize.get(classId);
    }

    public final void calculateShallowSize() {
        this.dump.getClasses().forEachClass((Function2<? super Long, ? super HprofClass, Unit>)((Function2)(arg_0, arg_1) -> ShallowSizeStorage.calculateShallowSize$lambda$2(this, arg_0, arg_1)));
    }

    private final long calculateArraySize(HprofClass klass, int length) {
        return ShallowSizeStorage.roundup$default(this, (long)this.arrayHeaderSize + (long)length * (long)this.oneElementSize(klass), 0, 2, null);
    }

    private final int oneElementSize(HprofClass klass) {
        return switch (klass.getName()) {
            case "boolean[]" -> this.objectLayout.getBooleanSize();
            case "byte[]" -> this.objectLayout.getByteSize();
            case "char[]" -> this.objectLayout.getCharSize();
            case "short[]" -> this.objectLayout.getShortSize();
            case "int[]" -> this.objectLayout.getIntSize();
            case "float[]" -> this.objectLayout.getFloatSize();
            case "long[]" -> this.objectLayout.getLongSize();
            case "double[]" -> this.objectLayout.getDoubleSize();
            default -> this.objectLayout.getOopsSize();
        };
    }

    private final int roundup(int value, int alignmentBytes) {
        return value + (1 << alignmentBytes) - 1 >> alignmentBytes << alignmentBytes;
    }

    static /* synthetic */ int roundup$default(ShallowSizeStorage shallowSizeStorage, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = shallowSizeStorage.objectLayout.getObjectAlignmentInBytes();
        }
        return shallowSizeStorage.roundup(n, n2);
    }

    private final long roundup(long value, int alignmentBytes) {
        return value + (long)(1 << alignmentBytes) - 1L >> alignmentBytes << alignmentBytes;
    }

    static /* synthetic */ long roundup$default(ShallowSizeStorage shallowSizeStorage, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = shallowSizeStorage.objectLayout.getObjectAlignmentInBytes();
        }
        return shallowSizeStorage.roundup(l, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit calculateShallowSize$lambda$2(ShallowSizeStorage this$0, long id, HprofClass hprofClass) {
        Intrinsics.checkNotNullParameter((Object)hprofClass, (String)"hprofClass");
        if (hprofClass.isArray()) {
            long totalSize = 0L;
            Int2IntOpenHashMap int2IntOpenHashMap = hprofClass.getArrayLengths();
            if (int2IntOpenHashMap != null) {
                Map $this$forEach$iv = (Map)int2IntOpenHashMap;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    Integer length = (Integer)entry.getKey();
                    Integer amount = (Integer)entry.getValue();
                    Intrinsics.checkNotNull((Object)length);
                    long l = this$0.calculateArraySize(hprofClass, length);
                    Intrinsics.checkNotNull((Object)amount);
                    totalSize += l * (long)amount.intValue();
                }
            }
            ((Map)this$0.classInstancesTotalSize).put(id, totalSize);
        } else {
            int oneInstanceSize = this$0.headerSize;
            List classes = CollectionsKt.reversed((Iterable)this$0.dump.getClasses().getClassHierarchy(id));
            for (HprofClass clazz : classes) {
                int n;
                InstanceFieldEntry[] instanceFieldEntryArray = clazz.getInstanceFields();
                int n2 = oneInstanceSize;
                int n3 = 0;
                int n4 = instanceFieldEntryArray.length;
                for (int i = 0; i < n4; ++i) {
                    void it;
                    InstanceFieldEntry instanceFieldEntry;
                    InstanceFieldEntry amount = instanceFieldEntry = instanceFieldEntryArray[i];
                    n = n3;
                    boolean bl = false;
                    int n5 = WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()] == 1 ? this$0.objectLayout.getOopsSize() : it.getType().getSize();
                    n3 = n + n5;
                }
                n = n3;
                oneInstanceSize = n2 + n;
                if (this$0.objectLayout.getOptimizeSubclassFieldsPacking()) continue;
                oneInstanceSize = ShallowSizeStorage.roundup$default(this$0, oneInstanceSize, 0, 2, null);
            }
            oneInstanceSize = ShallowSizeStorage.roundup$default(this$0, oneInstanceSize, 0, 2, null);
            ((Map)this$0.classInstancesShallowSize).put(id, oneInstanceSize);
            ((Map)this$0.classInstancesTotalSize).put(id, (long)oneInstanceSize * (long)hprofClass.getInstanceCount());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

