/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterConnectionActionExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterManagedServerExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerPackageInstalling;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarting;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStopped;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.py.helper.JupyterPyExtensionsKt;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.configuration.PythonSdkCreationWaiter;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u001a\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u0004\u0018\u00010\u001fH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getTextForConfig", "", "serverConfig", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createPopupActionGroup", "askUserConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "config", "getManagedServerStatusText", "interpreterName", "execution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "getIconForKernelState", "Ljavax/swing/Icon;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterExecutionState;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterServerChooserAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1563#2:242\n1634#2,3:243\n*S KotlinDebug\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction\n*L\n149#1:242\n149#1:243,3\n*E\n"})
public final class JupyterServerChooserAction
extends DefaultActionGroup
implements DumbAware,
ActionRemoteBehaviorSpecification.BackendOnly {
    public JupyterServerChooserAction() {
        Presentation presentation;
        Presentation $this$_init__u24lambda_u240 = presentation = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.setPerformGroup(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        Object object = inputEvent != null ? inputEvent.getSource() : null;
        Component component = object instanceof Component ? (Component)object : null;
        if (component == null) {
            return;
        }
        Component component2 = component;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Module module = JupyterPyExtensionsKt.getSuggestedModule(dataContext);
        if (module == null) {
            return;
        }
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Sdk pythonSdk = JupyterPyExtensionsKt.getPythonSdk(dataContext2);
        if (pythonSdk == null) {
            PySdkPopupFactory pySdkPopupFactory = new PySdkPopupFactory(module);
            DataContext dataContext3 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
            pySdkPopupFactory.createPopup(dataContext3).showUnderneathOf(component2);
            return;
        }
        DefaultActionGroup defaultActionGroup = this.createPopupActionGroup(e);
        if (defaultActionGroup == null) {
            return;
        }
        DefaultActionGroup actionGroup = defaultActionGroup;
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, e.getDataContext(), null, true, null).showUnderneathOf(component2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        if (!JupyterPyExtensionsKt.isPyNotebook(dataContext)) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) {
            return;
        }
        BackedNotebookVirtualFile virtualFile = backedNotebookVirtualFile;
        e.getPresentation().setEnabledAndVisible(true);
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Module module = JupyterPyExtensionsKt.getSuggestedModule(dataContext2);
        if (module == null) {
            e.getPresentation().setText(JupyterRemoteBundle.message((String)"action.JupyterServerChooserAction.text.no.module", (Object[])new Object[0]));
            e.getPresentation().setEnabled(false);
            return;
        }
        if (PythonSdkCreationWaiter.INSTANCE.isCreatingSdk(module)) {
            e.getPresentation().setText(JupyterPyBundle.message("progress.text.creating.python.sdk.label", new Object[0]));
            e.getPresentation().setIcon((Icon)new AnimatedIcon.Default());
            return;
        }
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        Sdk pythonSdk = JupyterPyExtensionsKt.getPythonSdk(dataContext3);
        if (pythonSdk == null) {
            e.getPresentation().setText(JupyterRemoteBundle.message((String)"Jupyter.managed.server.sdk.is.not.selected", (Object[])new Object[0]));
            e.getPresentation().setIcon(AllIcons.General.Warning);
            return;
        }
        JupyterExecutionState kernelState = JupyterConnectionActionExtensionsKt.getKernelState((AnActionEvent)e);
        e.getPresentation().setIcon(this.getIconForKernelState(kernelState));
        JupyterServerConfig savedSettings = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFileOrDefault((VirtualFile)virtualFile, project2);
        e.getPresentation().setText(this.getTextForConfig(savedSettings, e));
    }

    @NlsActions.ActionText
    private final String getTextForConfig(JupyterServerConfig serverConfig, AnActionEvent e) {
        String string;
        JupyterServerConfig jupyterServerConfig = serverConfig;
        if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Sdk sdk = JupyterPyExtensionsKt.getPythonSdk(dataContext);
            if (sdk == null) {
                return JupyterRemoteBundle.message((String)"Jupyter.managed.server.sdk.is.not.selected", (Object[])new Object[0]);
            }
            Sdk pythonSdk = sdk;
            JupyterServerExecution managedServerConfiguration = JupyterManagedServerExtensionsKt.getJupyterManagedServerExecution((AnActionEvent)e);
            String string2 = pythonSdk.getVersionString();
            if (string2 == null) {
                String string3 = pythonSdk.getName();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            }
            String pythonSdkName = string2;
            String name = JupyterConnectionSettingsManager.Companion.getInstance().isMoreThanOneManaged() ? ((JupyterManagedServerConfig)serverConfig).getName() + " (" + pythonSdkName + ")" : pythonSdkName;
            string = this.getManagedServerStatusText(name, managedServerConfiguration);
        } else if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            string = ((JupyterConfiguredServerConfig)serverConfig).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultActionGroup createPopupActionGroup(AnActionEvent e) {
        Object[] objectArray;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) {
            return null;
        }
        BackedNotebookVirtualFile virtualFile = backedNotebookVirtualFile;
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        JupyterConnectionSettingsManager settingsManager = JupyterConnectionSettingsManager.Companion.getInstance();
        List connections = !(virtualFile instanceof JupyterRemoteVirtualFile) ? settingsManager.getAll() : CollectionsKt.emptyList();
        JupyterServerConfig selectedConnection = settingsManager.getConfigForVirtualFileOrDefault((VirtualFile)virtualFile, project2);
        Iterable $this$map$iv = connections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void config;
            objectArray = (Object[])item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Icon icon = Intrinsics.areEqual((Object)config, (Object)selectedConnection) ? AllIcons.Actions.Checked : null;
            String name = this.getTextForConfig((JupyterServerConfig)config, e);
            collection.add(DumbAwareAction.create((String)name, (Icon)icon, arg_0 -> JupyterServerChooserAction.createPopupActionGroup$lambda$3$lambda$2(arg_0 -> JupyterServerChooserAction.createPopupActionGroup$lambda$3$lambda$1((JupyterServerConfig)config, selectedConnection, this, project2, (VirtualFile)virtualFile, settingsManager, arg_0), arg_0)));
        }
        List selectConnectionActions2 = (List)destination$iv$iv;
        AnAction openSettingsAction = ActionManager.getInstance().getAction("OpenJupyterSettingsAction");
        AnAction shutdownNotebookAction = ActionManager.getInstance().getAction("JupyterShutdownNotebookAction");
        AnAction switchKernelAction = ActionManager.getInstance().getAction("JupyterKernelManagementAction");
        AnAction connectToServer = ActionManager.getInstance().getAction("JupyterConnectToServerAction");
        Object object = JupyterManagedServerExtensionsKt.getCurrentKernel((AnActionEvent)e);
        if (object == null || (object = object.getDisplayName()) == null) {
            object = JupyterRemoteBundle.message((String)"separator.server.actions", (Object[])new Object[0]);
        }
        Object kernelSectionTitle = object;
        item$iv$iv2 = new AnAction[]{Separator.create((String)kernelSectionTitle), connectToServer, switchKernelAction, shutdownNotebookAction};
        List kernelActions = CollectionsKt.listOfNotNull(item$iv$iv2);
        objectArray = new AnAction[]{Separator.create(), openSettingsAction};
        List actionList = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)kernelActions, (Object)Separator.create((String)JupyterRemoteBundle.message((String)"separator.config.actions", (Object[])new Object[0]))), (Iterable)selectConnectionActions2), (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        return new DefaultActionGroup(actionList);
    }

    private final boolean askUserConfirmation(Project project, VirtualFile virtualFile, JupyterServerConfig config) {
        JupyterRuntimeService runtimeService = JupyterRuntimeService.Companion.getInstance(project);
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = runtimeService.getRuntime(virtualFile);
        if (jupyterNotebookRuntimeSettings == null) {
            return true;
        }
        JupyterNotebookRuntimeSettings runtime = jupyterNotebookRuntimeSettings;
        JupyterServerConfig runtimeConnection = runtime.getConnectionSettings();
        if (Intrinsics.areEqual((Object)config, (Object)runtimeConnection)) {
            return true;
        }
        Object[] objectArray = new Object[]{runtimeConnection.getName()};
        boolean isOk = Messages.showOkCancelDialog((Project)project, (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.message", (Object[])objectArray), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.title", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) == 0;
        return isOk;
    }

    @Nls
    private final String getManagedServerStatusText(String interpreterName, JupyterServerExecution execution) {
        String string;
        JupyterServerState state;
        JupyterServerExecution jupyterServerExecution = execution;
        Object object = state = jupyterServerExecution != null ? jupyterServerExecution.getState() : null;
        if (state == null || state instanceof JupyterServerStopped || state instanceof JupyterServerFinished) {
            Object[] objectArray = new Object[]{interpreterName};
            string = JupyterBundle.message((String)"Jupyter.managed.server.auto.start", (Object[])objectArray);
        } else if (state instanceof JupyterServerStarting) {
            Object[] objectArray = new Object[]{interpreterName};
            string = JupyterBundle.message((String)"Jupyter.managed.server.starting", (Object[])objectArray);
        } else if (state instanceof JupyterServerPackageInstalling) {
            Object[] objectArray = new Object[]{interpreterName};
            string = JupyterBundle.message((String)"Jupyter.managed.server.package.installing", (Object[])objectArray);
        } else if (state instanceof JupyterServerStarted) {
            Object[] objectArray = new Object[2];
            objectArray[0] = interpreterName;
            Intrinsics.checkNotNullExpressionValue((Object)((JupyterServerStarted)state).getConnectionParameters().getUri().toString(), (String)"toString(...)");
            string = JupyterBundle.message((String)"Jupyter.managed.server.running", (Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Icon getIconForKernelState(JupyterExecutionState $this$getIconForKernelState) {
        JupyterExecutionState jupyterExecutionState = $this$getIconForKernelState;
        return switch (jupyterExecutionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jupyterExecutionState.ordinal()]) {
            case 1 -> JupyterCoreIcons.Server.Jupyter_waiting;
            case 2 -> JupyterCoreIcons.Server.Jupyter_busy;
            case 3 -> JupyterCoreIcons.Server.Jupyter_waiting;
            case 4 -> JupyterCoreIcons.Server.Jupyter_error;
            case -1 -> JupyterCoreIcons.Server.Jupyter_stopped;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit createPopupActionGroup$lambda$3$lambda$1(JupyterServerConfig $config, JupyterServerConfig $selectedConnection, JupyterServerChooserAction this$0, Project $project, VirtualFile $virtualFile, JupyterConnectionSettingsManager $settingsManager, AnActionEvent it) {
        if (Intrinsics.areEqual((Object)$config, (Object)$selectedConnection)) {
            return Unit.INSTANCE;
        }
        if (!this$0.askUserConfirmation($project, $virtualFile, $config)) {
            return Unit.INSTANCE;
        }
        $settingsManager.setConfigForFile($virtualFile, $config);
        JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, $virtualFile, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        JupyterRuntimeService runtimeService = JupyterRuntimeService.Companion.getInstance(this.$project);
                        runtimeService.clearRuntime(this.$virtualFile);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final void createPopupActionGroup$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionState.values().length];
            try {
                nArray[JupyterExecutionState.STARTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.IDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

