/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.java.ChildAlignmentStrategyProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeAligner
extends ChildAlignmentStrategyProvider {
    private final List<AlignerConfigurationWrapper> myConfigurations = new ArrayList<AlignerConfigurationWrapper>();

    public CompositeAligner(List<AlignerConfiguration> configuration) {
        for (AlignerConfiguration alignerConfiguration : configuration) {
            this.myConfigurations.add(new AlignerConfigurationWrapper(alignerConfiguration));
        }
    }

    @Override
    public AlignmentStrategy getNextChildStrategy(@NotNull ASTNode child) {
        if (child == null) {
            CompositeAligner.$$$reportNull$$$0(0);
        }
        AlignerConfigurationWrapper currentAlignmentWrapper = null;
        for (AlignerConfigurationWrapper configuration : this.myConfigurations) {
            if (!configuration.myConfiguration.shouldAlign(child)) continue;
            currentAlignmentWrapper = configuration;
            break;
        }
        AlignerConfigurationWrapper wrapperWithStrategyToPreserve = CompositeAligner.isWhiteSpaceWithBlankLines(child.getTreePrev()) ? null : currentAlignmentWrapper;
        this.updateAllStrategiesExcept(wrapperWithStrategyToPreserve);
        return currentAlignmentWrapper == null ? AlignmentStrategy.getNullStrategy() : currentAlignmentWrapper.myCurrentStrategy;
    }

    private void updateAllStrategiesExcept(@Nullable AlignerConfigurationWrapper wrapper) {
        for (AlignerConfigurationWrapper configuration : this.myConfigurations) {
            if (configuration == wrapper) continue;
            configuration.update();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/java/CompositeAligner", "getNextChildStrategy"));
    }

    static interface AlignerConfiguration {
        public boolean shouldAlign(@NotNull ASTNode var1);

        @NotNull
        public AlignmentStrategy createStrategy();
    }

    private static final class AlignerConfigurationWrapper {
        private final AlignerConfiguration myConfiguration;
        private AlignmentStrategy myCurrentStrategy;

        private AlignerConfigurationWrapper(AlignerConfiguration configuration) {
            this.myConfiguration = configuration;
            this.myCurrentStrategy = configuration.createStrategy();
        }

        void update() {
            this.myCurrentStrategy = this.myConfiguration.createStrategy();
        }
    }
}

