/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif.textFormat;

import com.vladsch.flexmark.html2md.converter.CustomHtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.HtmlConverterOptions;
import com.vladsch.flexmark.html2md.converter.HtmlMarkdownWriter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.html2md.converter.internal.HtmlConverterCoreNodeRenderer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

class PreElementHtmlRenderer
implements CustomHtmlNodeRenderer<Element> {
    @NotNull
    private final HtmlConverterOptions myHtmlConverterOptions;

    PreElementHtmlRenderer(@NotNull DataHolder options) {
        if (options == null) {
            PreElementHtmlRenderer.$$$reportNull$$$0(0);
        }
        this.myHtmlConverterOptions = new HtmlConverterOptions(options);
    }

    public void render(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        Node next;
        context.pushState((Node)element);
        boolean hadCode = false;
        String className = "";
        HtmlNodeConverterContext preText = context.getSubContext();
        preText.getMarkdown().setOptions(out.getOptions() & ~(LineAppendable.F_COLLAPSE_WHITESPACE | LineAppendable.F_TRIM_TRAILING_WHITESPACE));
        preText.getMarkdown().openPreFormatted(false);
        while ((next = context.next()) != null) {
            if (next.nodeName().equalsIgnoreCase("code") || next.nodeName().equalsIgnoreCase("tt")) {
                hadCode = true;
                Element code = (Element)next;
                preText.inlineCode(() -> preText.renderChildren((Node)code, false, null));
                if (!className.isEmpty()) continue;
                className = Utils.removePrefix((String)code.className(), (String)"language-");
                continue;
            }
            if (next.nodeName().equalsIgnoreCase("br")) {
                preText.getMarkdown().append((CharSequence)"\n");
                continue;
            }
            if (next.nodeName().equalsIgnoreCase("#text")) {
                preText.getMarkdown().append((CharSequence)((TextNode)next).getWholeText());
                continue;
            }
            preText.renderChildren(next, false, null);
        }
        preText.getMarkdown().closePreFormatted();
        String text2 = preText.getMarkdown().toString(Integer.MAX_VALUE, 2);
        int backTickCount = HtmlConverterCoreNodeRenderer.getMaxRepeatedChars((CharSequence)text2, (char)'`', (int)3);
        CharSequence backTicks = RepeatedSequence.repeatOf((CharSequence)"`", (int)backTickCount);
        if (!(this.myHtmlConverterOptions.skipFencedCode || className.isEmpty() && !text2.trim().isEmpty() && hadCode)) {
            ((HtmlMarkdownWriter)out.blankLine()).append(backTicks);
            if (!className.isEmpty()) {
                out.append((CharSequence)className);
            }
            out.line();
            out.openPreFormatted(true);
            out.append((CharSequence)(text2.isEmpty() ? "\n" : text2));
            out.closePreFormatted();
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.line()).append(backTicks)).line();
            out.tailBlankLine();
        } else {
            out.blankLine();
            out.pushPrefix();
            out.addPrefix((CharSequence)this.myHtmlConverterOptions.codeIndent);
            out.openPreFormatted(true);
            out.append((CharSequence)(text2.isEmpty() ? "\n" : text2));
            out.closePreFormatted();
            out.line();
            out.tailBlankLine();
            out.popPrefix();
        }
        context.popState((LineAppendable)out);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/qodana/staticAnalysis/sarif/textFormat/PreElementHtmlRenderer", "<init>"));
    }
}

