/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.DotplotStat;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ;\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014H\u0016JL\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001d0\u001b2\u0006\u0010\u0010\u001a\u00020\u000f2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001d2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0012\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u001dH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/YDotplotStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "binCount", "", "binWidth", "", "xPosKind", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;", "xPos", "method", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "(ILjava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;DLorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;)V", "binOptions", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "buildStat", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "", "xs", "ys", "rangeY", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nYDotplotStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YDotplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/YDotplotStat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,99:1\n1#2:100\n766#3:101\n857#3,2:102\n1490#3:104\n1520#3,3:105\n1523#3,3:115\n372#4,7:108\n*S KotlinDebug\n*F\n+ 1 YDotplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/YDotplotStat\n*L\n64#1:101\n64#1:102,2\n65#1:104\n65#1:105,3\n65#1:115,3\n65#1:108,7\n*E\n"})
public final class YDotplotStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BinStat.XPosKind xPosKind;
    private final double xPos;
    @NotNull
    private final DotplotStat.Method method;
    @NotNull
    private final BinStatUtil.BinOptions binOptions;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public YDotplotStat(int binCount, @Nullable Double binWidth, @NotNull BinStat.XPosKind xPosKind, double xPos, @NotNull DotplotStat.Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        super(DEF_MAPPING);
        this.xPosKind = xPosKind;
        this.xPos = xPos;
        this.method = method;
        this.binOptions = new BinStatUtil.BinOptions(binCount, binWidth);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data2, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getY()};
        if (!this.hasRequiredValues(data2, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> ys = data2.getNumeric(TransformVar.INSTANCE.getY());
        if (data2.has(TransformVar.INSTANCE.getX())) {
            list2 = data2.getNumeric(TransformVar.INSTANCE.getX());
        } else {
            int n = ys.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(0.0);
            }
            list2 = arrayList;
        }
        List xs = list2;
        Map<DataFrame.Variable, List<Double>> statData = this.buildStat(data2, xs, ys, statCtx.overallYRange());
        DataFrame.Builder builder = new DataFrame.Builder();
        for (Map.Entry<DataFrame.Variable, List<Double>> entry : statData.entrySet()) {
            DataFrame.Variable variable = entry.getKey();
            List<Double> series = entry.getValue();
            builder.putNumeric(variable, series);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> buildStat(DataFrame data2, List<Double> xs, List<Double> ys, DoubleSpan rangeY) {
        ArrayList statX = new ArrayList();
        ArrayList statY = new ArrayList();
        ArrayList statCount = new ArrayList();
        ArrayList statDensity = new ArrayList();
        ArrayList statBinWidth = new ArrayList();
        if (rangeY != null) {
            ArrayList<Double> arrayList;
            int $i$f$getOrPut;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Pair it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = CollectionsKt.zip((Iterable)xs, (Iterable)ys);
            boolean bl = false;
            void var13_14 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl2 = false;
                if (!SeriesUtil.INSTANCE.isFinite((Double)it.getFirst())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean entry = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it2;
                Object object;
                it = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-YDotplotStat$buildStat$groupedData$432 = false;
                Object object2 = it.getFirst();
                Intrinsics.checkNotNull((Object)object2);
                Double key$iv$iv = ((Number)object2).doubleValue();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = 0;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                ArrayList<Double> list$iv$iv = (ArrayList<Double>)object;
                Pair $i$a$-groupBy-YDotplotStat$buildStat$groupedData$432 = (Pair)element$iv$iv;
                arrayList = list$iv$iv;
                boolean bl4 = false;
                arrayList.add((Double)it2.getSecond());
            }
            Object groupedData = destination$iv$iv;
            for (Map.Entry entry2 : groupedData.entrySet()) {
                BinStatUtil.BinsData binsData;
                double x2 = ((Number)entry2.getKey()).doubleValue();
                List ysGroup = (List)entry2.getValue();
                switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
                    case 1: {
                        binsData = BinStatUtil.INSTANCE.computeDotdensityStatSeries(rangeY, ysGroup, this.binOptions);
                        break;
                    }
                    case 2: {
                        binsData = BinStatUtil.INSTANCE.computeHistogramStatSeries(data2, rangeY, ysGroup, this.xPosKind, this.xPos, this.binOptions);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                BinStatUtil.BinsData binsData2 = binsData;
                Collection collection = statX;
                int n = binsData2.getX$plot_base().size();
                ArrayList<Double> arrayList2 = new ArrayList<Double>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    $i$f$getOrPut = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl5 = false;
                    arrayList.add(x2);
                }
                Iterable n4 = arrayList2;
                CollectionsKt.addAll((Collection)collection, (Iterable)n4);
                CollectionsKt.addAll((Collection)statY, (Iterable)binsData2.getX$plot_base());
                CollectionsKt.addAll((Collection)statCount, (Iterable)binsData2.getCount$plot_base());
                CollectionsKt.addAll((Collection)statDensity, (Iterable)binsData2.getDensity$plot_base());
                CollectionsKt.addAll((Collection)statBinWidth, (Iterable)binsData2.getBinWidth$plot_base());
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), statX), TuplesKt.to((Object)Stats.INSTANCE.getY(), statY), TuplesKt.to((Object)Stats.INSTANCE.getCOUNT(), statCount), TuplesKt.to((Object)Stats.INSTANCE.getDENSITY(), statDensity), TuplesKt.to((Object)Stats.INSTANCE.getBIN_WIDTH(), statBinWidth)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getSTACKSIZE(), (Object)Stats.INSTANCE.getCOUNT()), TuplesKt.to(Aes.Companion.getBINWIDTH(), (Object)Stats.INSTANCE.getBIN_WIDTH())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/YDotplotStat$Companion;", "", "()V", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DotplotStat.Method.values().length];
            try {
                nArray[DotplotStat.Method.DOTDENSITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DotplotStat.Method.HISTODOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

