/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.ArrayBackedFMap;
import com.intellij.util.fmap.FMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MapBackedFMap<K, V>
implements FMap<K, V> {
    @NotNull
    private final Map<K, V> myMap;

    MapBackedFMap(@NotNull Map<K, V> map2) {
        if (map2 == null) {
            MapBackedFMap.$$$reportNull$$$0(0);
        }
        assert (map2.size() > 8);
        this.myMap = map2;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(@NotNull K key, @NotNull V value) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(1);
        }
        if (value == null) {
            MapBackedFMap.$$$reportNull$$$0(2);
        }
        if (value.equals(this.myMap.get(key))) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(3);
            }
            return mapBackedFMap;
        }
        HashMap<K, V> newMap = new HashMap<K, V>(this.myMap);
        newMap.put(key, value);
        return new MapBackedFMap<K, V>(newMap);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(@NotNull K key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(4);
        }
        if (!this.myMap.containsKey(key)) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(5);
            }
            return mapBackedFMap;
        }
        HashMap<K, V> newMap = new HashMap<K, V>(this.myMap);
        newMap.remove(key);
        if (newMap.size() > 8) {
            return new MapBackedFMap<K, V>(newMap);
        }
        return new ArrayBackedFMap<K, V>(newMap);
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(6);
        }
        return this.myMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        Set<K> set = Collections.unmodifiableSet(this.myMap.keySet());
        if (set == null) {
            MapBackedFMap.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        Map<K, V> map2 = Collections.unmodifiableMap(this.myMap);
        if (map2 == null) {
            MapBackedFMap.$$$reportNull$$$0(8);
        }
        return map2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBackedFMap map2 = (MapBackedFMap)o;
        return this.myMap.equals(map2.myMap);
    }

    public int hashCode() {
        return Objects.hash(this.myMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (Map.Entry<K, V> entry : this.myMap.entrySet()) {
            sb.append("  ").append(entry.getKey()).append(": ").append(entry.getValue()).append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/fmap/MapBackedFMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/fmap/MapBackedFMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

