/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.diff;

import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerDumpParserProviderFinder;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ProfilerDumpParserProviderKt;
import com.intellij.profiler.diff.ProfilerCallStackElementsCombiner;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.async.AsyncProfilerDumpParserProvider;
import com.intellij.profiler.ultimate.jfr.JFRDumpParserProvider;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/diff/JavaProfilerCallStackElementsCombiner;", "Lcom/intellij/profiler/diff/ProfilerCallStackElementsCombiner;", "<init>", "()V", "isApplicableTo", "", "processPanel", "Lcom/intellij/profiler/ProfilerProcessPanel;", "dumpPanel", "Lcom/intellij/profiler/ProfilerDumpPanel;", "same", "first", "Lcom/intellij/profiler/api/BaseCallStackElement;", "second", "combineSame", "getNameWithoutGeneratedSymbols", "", "Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "intellij.profiler.ultimate"})
public final class JavaProfilerCallStackElementsCombiner
extends ProfilerCallStackElementsCombiner {
    protected boolean isApplicableTo(@NotNull ProfilerProcessPanel processPanel) {
        Intrinsics.checkNotNullParameter((Object)processPanel, (String)"processPanel");
        return processPanel.getProfilerProcess() instanceof JavaProfilerProcess;
    }

    protected boolean isApplicableTo(@NotNull ProfilerDumpPanel dumpPanel) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dumpPanel, (String)"dumpPanel");
        File file = dumpPanel.getSnapshotFile();
        if (file == null) {
            Object[] objectArray = new String[]{"jfr", "collapsed"};
            return CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)dumpPanel.getFileExtension());
        }
        ProfilerDumpParserProviderFinder providerFinder = new ProfilerDumpParserProviderFinder();
        ProfilerDumpParserProviderFinder.Result result = providerFinder.findParserProvider(file, ProfilerDumpParserProviderKt.getProfilerDumpParserProviders());
        if (result instanceof ProfilerDumpParserProviderFinder.Result.Failure) {
            bl = false;
        } else if (result instanceof ProfilerDumpParserProviderFinder.Result.Success) {
            bl = ((ProfilerDumpParserProviderFinder.Result.Success)result).getProvider() instanceof JFRDumpParserProvider || ((ProfilerDumpParserProviderFinder.Result.Success)result).getProvider() instanceof AsyncProfilerDumpParserProvider;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public boolean same(@NotNull BaseCallStackElement first, @NotNull BaseCallStackElement second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (first instanceof BaseJavaMethodCall && second instanceof BaseJavaMethodCall) {
            return Intrinsics.areEqual((Object)((BaseJavaMethodCall)first).getFormalDescriptor(), (Object)((BaseJavaMethodCall)second).getFormalDescriptor()) && Intrinsics.areEqual((Object)((BaseJavaMethodCall)first).getMethodName(), (Object)((BaseJavaMethodCall)second).getMethodName()) && Intrinsics.areEqual((Object)this.getNameWithoutGeneratedSymbols((BaseJavaMethodCall)first), (Object)this.getNameWithoutGeneratedSymbols((BaseJavaMethodCall)second)) && Intrinsics.areEqual((Object)((BaseJavaMethodCall)first).getFullPackageName(), (Object)((BaseJavaMethodCall)second).getFullPackageName());
        }
        return Intrinsics.areEqual((Object)first.fullName(), (Object)second.fullName());
    }

    @NotNull
    public BaseCallStackElement combineSame(@NotNull BaseCallStackElement first, @NotNull BaseCallStackElement second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        BaseJavaMethodCall baseJavaMethodCall = first instanceof BaseJavaMethodCall ? (BaseJavaMethodCall)first : null;
        if (baseJavaMethodCall == null) {
            return first;
        }
        BaseJavaMethodCall element = baseJavaMethodCall;
        String reducedName = this.getNameWithoutGeneratedSymbols(element);
        if (Intrinsics.areEqual((Object)element.getClassName(), (Object)reducedName)) {
            return first;
        }
        return ((BaseJavaMethodCall)first).copyWithCustomName(reducedName);
    }

    private final String getNameWithoutGeneratedSymbols(BaseJavaMethodCall $this$getNameWithoutGeneratedSymbols) {
        return BaseJavaMethodCall.Companion.simplifyGeneratedClassName($this$getNameWithoutGeneratedSymbols.getClassName());
    }
}

