/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.ui;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.TreeNodeKt;
import com.intellij.profiler.model.TreeNodeWithParent;
import com.intellij.profiler.ui.CommonProfilerTabNameWithId;
import com.intellij.profiler.ui.ProfilerTabComponentNameWithId;
import com.intellij.profiler.ui.threadview.UIVisibleThreadInfo;
import com.intellij.profiler.ui.timeline.DefaultNode;
import com.intellij.profiler.ui.timeline.TimelineEventUIContentProvider;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.jfr.ui.HeavyJfrTimelineEvent;
import com.intellij.profiler.ultimate.jfr.ui.JFRTimelineEvent;
import com.intellij.profiler.ultimate.jfr.ui.JfrStackFramesList;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001f2\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J0\u0010\u0019\u001a\u00020\r2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/ultimate/jfr/ui/JFRTimelineEventUIContentProvider;", "Lcom/intellij/profiler/ui/timeline/TimelineEventUIContentProvider;", "Lcom/intellij/profiler/ui/timeline/DefaultNode;", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "Lcom/intellij/profiler/ultimate/jfr/ui/JFRTimelineEvent;", "Ljavax/swing/JScrollPane;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myStackFramesList", "Lcom/intellij/profiler/ultimate/jfr/ui/JfrStackFramesList;", "expandableButtonText", "", "getExpandableButtonText", "()Ljava/lang/String;", "collapseButtonTooltipText", "getCollapseButtonTooltipText", "createUIContent", "getPanel", "Ljavax/swing/JComponent;", "uiContent", "updateComponent", "", "eventContent", "getHeaderText", "treeComponent", "event", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "timePassedMs", "", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRDumpView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRDumpView.kt\ncom/intellij/profiler/ultimate/jfr/ui/JFRTimelineEventUIContentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1869#2:757\n1870#2:759\n1#3:758\n*S KotlinDebug\n*F\n+ 1 JFRDumpView.kt\ncom/intellij/profiler/ultimate/jfr/ui/JFRTimelineEventUIContentProvider\n*L\n733#1:757\n733#1:759\n*E\n"})
final class JFRTimelineEventUIContentProvider
implements TimelineEventUIContentProvider<DefaultNode<UIVisibleThreadInfo>, JFRTimelineEvent, JScrollPane> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JfrStackFramesList myStackFramesList;

    /*
     * WARNING - void declaration
     */
    public JFRTimelineEventUIContentProvider(@NotNull Project project) {
        void $this$myStackFramesList_u24lambda_u240;
        JfrStackFramesList jfrStackFramesList;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JfrStackFramesList jfrStackFramesList2 = jfrStackFramesList = new JfrStackFramesList(project, (ProfilerTabComponentNameWithId)CommonProfilerTabNameWithId.TIMELINE);
        JFRTimelineEventUIContentProvider jFRTimelineEventUIContentProvider = this;
        boolean bl = false;
        $this$myStackFramesList_u24lambda_u240.getEmptyText().setText(UltimateProfilerBundleKt.profilerMessage("jfr.ui.timeline.content.empty.text", new Object[0]));
        jFRTimelineEventUIContentProvider.myStackFramesList = jfrStackFramesList;
    }

    @NotNull
    public String getExpandableButtonText() {
        return UltimateProfilerBundleKt.profilerMessage("jfr.ui.timeline.content.button.title", new Object[0]);
    }

    @NotNull
    public String getCollapseButtonTooltipText() {
        return UltimateProfilerBundleKt.profilerMessage("jfr.ui.timeline.content.view.hide", new Object[0]);
    }

    @NotNull
    public JScrollPane createUIContent() {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.myStackFramesList)));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        return jScrollPane;
    }

    @NotNull
    public JComponent getPanel(@NotNull JScrollPane uiContent) {
        Intrinsics.checkNotNullParameter((Object)uiContent, (String)"uiContent");
        return uiContent;
    }

    public void updateComponent(@Nullable JFRTimelineEvent eventContent, @NotNull JScrollPane uiContent) {
        Intrinsics.checkNotNullParameter((Object)uiContent, (String)"uiContent");
        ListModel listModel = this.myStackFramesList.getModel();
        Intrinsics.checkNotNull((Object)listModel, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionListModel<com.intellij.profiler.api.BaseCallStackElement>");
        CollectionListModel model2 = (CollectionListModel)listModel;
        model2.removeAll();
        if (!(eventContent instanceof HeavyJfrTimelineEvent)) {
            this.myStackFramesList.getEmptyText().setText(UltimateProfilerBundleKt.profilerMessage("jfr.ui.timeline.content.no.data.available", new Object[0]));
            return;
        }
        Iterable $this$forEach$iv = (Iterable)TreeNodeKt.parentsIterable((TreeNodeWithParent)((TreeNodeWithParent)((HeavyJfrTimelineEvent)eventContent).getTop()), (boolean)true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CallTreeNode node = (CallTreeNode)element$iv;
            boolean bl = false;
            CallWithValue callWithValue = (CallWithValue)node.getData();
            if (callWithValue == null || (callWithValue = (BaseCallStackElement)callWithValue.getCall()) == null) continue;
            CallWithValue p0 = callWithValue;
            boolean bl2 = false;
            model2.add((Object)p0);
        }
    }

    @NotNull
    public String getHeaderText(@Nullable DefaultNode<UIVisibleThreadInfo> treeComponent, @Nullable TimelineModel.TimelineInterval<JFRTimelineEvent> event, long timePassedMs) {
        Object object = treeComponent;
        if (object == null || (object = (UIVisibleThreadInfo)object.getData()) == null || (object = object.getThreadInfo()) == null || (object = object.getName()) == null) {
            return this.getExpandableButtonText();
        }
        Object threadName = object;
        Object[] objectArray = new Object[]{threadName, JFRTimelineEventUIContentProvider.Companion.makePrettyDuration(timePassedMs)};
        return UltimateProfilerBundleKt.profilerMessage("jfr.ui.timeline.content.header.full", objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/ui/JFRTimelineEventUIContentProvider$Companion;", "", "<init>", "()V", "makePrettyDuration", "", "durationMs", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        private final String makePrettyDuration(long durationMs) {
            long millis = durationMs % (long)1000;
            long seconds = TimeUnit.MILLISECONDS.toSeconds(durationMs) % (long)60;
            long minutes = TimeUnit.MILLISECONDS.toMinutes(durationMs) % (long)60;
            long hours = TimeUnit.MILLISECONDS.toHours(durationMs);
            String string = "%02d:%02d:%02d.%03d";
            Object[] objectArray = new Object[]{hours, minutes, seconds, millis};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

