/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBpbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class CBStopMonitor
extends JButton {
    Thread thingToStop = null;
    boolean debugStopMon = false;
    CBpbar pbar = null;

    public CBStopMonitor(String text, Icon icon) {
        super(text, icon);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CBStopMonitor.this.debugStopMon) {
                    System.out.println("StopMon button pressed; about to stop " + (CBStopMonitor.this.thingToStop == null ? "null" : CBStopMonitor.this.thingToStop.getName()));
                }
                CBStopMonitor.this.stop(CBStopMonitor.this.thingToStop);
            }
        });
    }

    public void register(Thread stopMe, CBpbar newPbar) {
        if (this.debugStopMon) {
            System.out.println("StopMon registering thread " + (stopMe == null ? "null" : stopMe.getName()));
        }
        this.stop(this.thingToStop);
        this.pbar = newPbar;
        this.thingToStop = stopMe;
        this.setEnabled(true);
    }

    public void free(Thread ignoreMe) {
        if (this.debugStopMon) {
            System.out.println("StopMon de-registering thread " + (ignoreMe == null ? "null" : ignoreMe.getName()));
        }
        if (this.thingToStop == ignoreMe) {
            this.thingToStop = null;
            if (this.pbar != null) {
                this.pbar.close();
            }
        }
        this.setEnabled(false);
    }

    public void stop(Thread stopMe) {
        if (this.debugStopMon) {
            System.out.println("StopMon asked to stop thread " + (stopMe == null ? "null" : stopMe.getName()));
        }
        if (this.thingToStop == stopMe) {
            if (stopMe == null) {
                return;
            }
            if (this.pbar != null) {
                this.pbar.close();
            }
            this.thingToStop.interrupt();
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.thingToStop.isInterrupted()) {
                if (this.debugStopMon) {
                    System.out.println("attempting to force thread stoppage");
                }
            } else if (this.debugStopMon) {
                System.out.println("StopMon interrupting thread " + (this.thingToStop == null ? "null" : this.thingToStop.getName() + " :" + this.thingToStop.isInterrupted()));
            }
            this.thingToStop = null;
            this.setEnabled(false);
        } else if (this.debugStopMon) {
            System.out.println("unable to stop: " + stopMe.getName() + " - not registered");
        }
    }

    public boolean isBusy() {
        return this.isEnabled();
    }

    public boolean abandonAnyExistingOperation() {
        if (this.thingToStop != null) {
            int option = JOptionPane.showConfirmDialog(this, "You are already doing an operation.  Cancel the old one and start a new operation?", "Cancel Old Operation", 0);
            if (option == 0) {
                this.stop(this.thingToStop);
                return true;
            }
            return false;
        }
        return true;
    }
}

