/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.logstash.RubyUtil;

public class CloudSettingId {
    public static final String DOT_SEPARATOR = ".";
    public static final String CLOUD_PORT = "443";
    private String original;
    private String decoded;
    private String label;
    private String elasticsearchScheme;
    private String elasticsearchHost;
    private String elasticsearchPort;
    private String kibanaScheme;
    private String kibanaHost;
    private String kibanaPort;
    private String[] otherIdentifiers = new String[0];

    public CloudSettingId(String value) {
        if (value == null) {
            return;
        }
        this.original = value;
        String[] parts = this.original.split(":");
        this.label = parts[0];
        String encoded = null;
        if (parts.length > 1) {
            encoded = parts[1];
        }
        if (encoded == null || encoded.isEmpty()) {
            try {
                this.decoded = new String(Base64.getUrlDecoder().decode(this.label), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException iaex) {
                this.decoded = "";
            }
            this.label = "";
        } else {
            try {
                this.decoded = new String(Base64.getUrlDecoder().decode(encoded), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException iaex) {
                this.decoded = "";
            }
        }
        long separatorCount = this.decoded.chars().filter(c -> c == 36).count();
        if (separatorCount < 2L) {
            throw RubyUtil.RUBY.newArgumentError("Cloud Id, after decoding, is invalid. Format: '<segment1>$<segment2>$<segment3>'. Received: \"" + this.decoded + "\".");
        }
        String[] segments = this.decoded.split("\\$");
        if (Arrays.stream(segments).anyMatch(String::isEmpty)) {
            throw RubyUtil.RUBY.newArgumentError("Cloud Id, after decoding, is invalid. Format: '<segment1>$<segment2>$<segment3>'. Received: \"" + this.decoded + "\".");
        }
        String cloudBase = segments[0];
        String cloudHost = DOT_SEPARATOR + cloudBase;
        String[] hostParts = cloudHost.split(":");
        HostAndPort cloud = new HostAndPort(hostParts[0], hostParts.length > 1 ? hostParts[1] : CLOUD_PORT);
        HostAndPort elasticsearch = HostAndPort.parseHostAndPort(segments[1], "Cloud Id, after decoding, elasticsearch segment is 'undefined', literally.");
        this.elasticsearchPort = elasticsearch.portOrDefault(cloud.port);
        this.elasticsearchHost = elasticsearch.host + cloud.host + ":" + this.elasticsearchPort;
        this.elasticsearchScheme = "https";
        HostAndPort kibana = segments.length > 2 ? HostAndPort.parseHostAndPort(segments[2], "Cloud Id, after decoding, the kibana segment is 'undefined', literally. You may need to enable Kibana in the Cloud UI.") : HostAndPort.NO_HOST;
        this.kibanaPort = kibana.portOrDefault(cloud.port);
        this.kibanaHost = kibana.host + cloud.host + ":" + this.kibanaPort;
        this.kibanaScheme = "https";
        if (segments.length > 3) {
            this.otherIdentifiers = Arrays.copyOfRange(segments, 3, segments.length);
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public String getDecoded() {
        return this.decoded;
    }

    public String getLabel() {
        return this.label;
    }

    public String getElasticsearchScheme() {
        return this.elasticsearchScheme;
    }

    public String getElasticsearchHost() {
        return this.elasticsearchHost;
    }

    public String getElasticsearchPort() {
        return this.elasticsearchPort;
    }

    public String getKibanaScheme() {
        return this.kibanaScheme;
    }

    public String getKibanaHost() {
        return this.kibanaHost;
    }

    public String getKibanaPort() {
        return this.kibanaPort;
    }

    public String[] getOtherIdentifiers() {
        return this.otherIdentifiers;
    }

    public String toString() {
        return this.decoded;
    }

    public static String cloudIdEncode(String ... args) {
        String joinedArgs = String.join((CharSequence)"$", args);
        return Base64.getUrlEncoder().encodeToString(joinedArgs.getBytes());
    }

    private static class HostAndPort {
        static final HostAndPort NO_HOST = new HostAndPort("", null);
        private final String host;
        private final String port;

        private HostAndPort(String host, String port) {
            this.host = host;
            this.port = port;
        }

        String portOrDefault(String defaultPort) {
            return this.port == null ? defaultPort : this.port;
        }

        static HostAndPort parseHostAndPort(String part, String guidanceMessageWhenHostEqualsUndefined) {
            String[] hostParts = part.split(":");
            String host = hostParts[0];
            if ("undefined".equals(host)) {
                throw RubyUtil.RUBY.newArgumentError(guidanceMessageWhenHostEqualsUndefined);
            }
            String port = null;
            if (hostParts.length > 1) {
                port = hostParts[1];
            }
            return new HostAndPort(host, port);
        }
    }
}

