/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class RootExpression
extends Expression {
    private boolean contextMaybeUndefined = true;

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (contextInfo == null || contextInfo.getItemType() == null) {
            XPathException err = new XPathException(this.noContextMessage() + ": the context item is absent");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        this.contextMaybeUndefined = contextInfo.isPossiblyAbsent();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType(contextInfo.getItemType(), NodeKindTest.DOCUMENT)) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setStaticInfo(contextInfo);
            return cie;
        }
        int relation = th.relationship(contextInfo.getItemType(), AnyNodeTest.getInstance());
        if (relation == 4) {
            XPathException err = new XPathException(this.noContextMessage() + ": the context item is not a node");
            err.setErrorCode("XPTY0020");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this.typeCheck(visitor, contextItemType);
    }

    public int computeSpecialProperties() {
        return 0xC30000;
    }

    public boolean isContextPossiblyUndefined() {
        return this.contextMaybeUndefined;
    }

    protected String noContextMessage() {
        return "Leading '/' cannot select the root node of the tree containing the context item";
    }

    public boolean equals(Object other) {
        return other instanceof RootExpression;
    }

    public final int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType() {
        return NodeKindTest.DOCUMENT;
    }

    public int hashCode() {
        return "RootExpression".hashCode();
    }

    public NodeInfo getNode(XPathContext context) throws XPathException {
        Item current = context.getContextItem();
        if (current == null) {
            this.dynamicError("Finding root of tree: the context item is absent", "XPDY0002", context);
        }
        if (current instanceof NodeInfo) {
            DocumentInfo doc = ((NodeInfo)current).getDocumentRoot();
            if (doc == null) {
                this.dynamicError("The root of the tree containing the context item is not a document node", "XPDY0050", context);
            }
            return doc;
        }
        this.typeError("Finding root of tree: the context item is not a node", "XPTY0020", context);
        return null;
    }

    public int getIntrinsicDependencies() {
        return 16;
    }

    public Expression copy() {
        return new RootExpression();
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        return new NodeTestPattern(NodeKindTest.DOCUMENT);
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setContainer(this.getContainer());
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        return pathMapNodeSet.createArc((byte)1, NodeKindTest.DOCUMENT);
    }

    public String toString() {
        return "(/)";
    }

    public String getExpressionName() {
        return "(/)";
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("root");
        destination.endElement();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return SingletonIterator.makeIterator(this.getNode(context));
    }

    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        return this.getNode(context);
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.getNode(context) != null;
    }
}

