/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min(i64vec4(-20l, -20l, -20l, -20l), i64vec4(-20l, -6l, 6l, 20l)) => i64vec4(-20l, -20l, -20l, -20l)
 * min(i64vec4(-6l, -6l, -6l, -6l), i64vec4(-20l, -6l, 6l, 20l)) => i64vec4(-20l, -6l, -6l, -6l)
 * min(i64vec4(6l, 6l, 6l, 6l), i64vec4(-20l, -6l, 6l, 20l)) => i64vec4(-20l, -6l, 6l, 6l)
 * min(i64vec4(20l, 20l, 20l, 20l), i64vec4(-20l, -6l, 6l, 20l)) => i64vec4(-20l, -6l, 6l, 20l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal(min(i64vec4(-20l, -20l, -20l, -20l), i64vec4(-20l, -6l, 6l, 20l)), i64vec4(-20l, -20l, -20l, -20l))) ? 1 : -1] array0;
  float[all(equal(min(i64vec4(-6l, -6l, -6l, -6l), i64vec4(-20l, -6l, 6l, 20l)), i64vec4(-20l, -6l, -6l, -6l))) ? 1 : -1] array1;
  float[all(equal(min(i64vec4(6l, 6l, 6l, 6l), i64vec4(-20l, -6l, 6l, 20l)), i64vec4(-20l, -6l, 6l, 6l))) ? 1 : -1] array2;
  float[all(equal(min(i64vec4(20l, 20l, 20l, 20l), i64vec4(-20l, -6l, 6l, 20l)), i64vec4(-20l, -6l, 6l, 20l))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
