/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.threading;

import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reflection.ReflectionUtilKt;
import com.jetbrains.rd.util.threading.SchedulerUtilKt;
import com.jetbrains.rd.util.threading.SequentialScheduler;
import com.jetbrains.rd.util.threading.SpinWait;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u000b"}, d2={"asRdScheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "Ljava/util/concurrent/Executor;", "getAsRdScheduler", "(Ljava/util/concurrent/Executor;)Lcom/jetbrains/rd/util/reactive/IScheduler;", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lkotlinx/coroutines/CoroutineDispatcher;)Lcom/jetbrains/rd/util/reactive/IScheduler;", "executionOrder", "Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "dispatcherExecutionOrder", "asSequentialScheduler", "rd-core"})
public final class SchedulerUtilKt {
    @NotNull
    public static final IScheduler getAsRdScheduler(@NotNull Executor $this$asRdScheduler) {
        Intrinsics.checkNotNullParameter((Object)$this$asRdScheduler, (String)"<this>");
        return SchedulerUtilKt.asRdScheduler($this$asRdScheduler, ExecutionOrder.Unknown);
    }

    @NotNull
    public static final IScheduler asRdScheduler(@NotNull Executor $this$asRdScheduler, @NotNull ExecutionOrder executionOrder) {
        Intrinsics.checkNotNullParameter((Object)$this$asRdScheduler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)executionOrder), (String)"executionOrder");
        Executor executor2 = $this$asRdScheduler;
        IScheduler iScheduler = executor2 instanceof IScheduler ? (IScheduler)((Object)executor2) : null;
        if (iScheduler == null) {
            iScheduler = new IScheduler(executionOrder, executor2){
                static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
                @NotNull
                private final AtomicInteger tasksInQueue;
                @NotNull
                private final ReadWriteProperty active$delegate;
                final /* synthetic */ ExecutionOrder $executionOrder;
                final /* synthetic */ Executor $executor;
                {
                    this.$executionOrder = $executionOrder;
                    this.$executor = $executor;
                    this.tasksInQueue = new AtomicInteger();
                    this.active$delegate = ReflectionUtilKt.threadLocal(asRdScheduler.active.2.INSTANCE);
                }

                private final int getActive() {
                    return ((Number)this.active$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
                }

                private final void setActive(int n) {
                    this.active$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
                }

                public boolean isActive() {
                    return this.getActive() > 0;
                }

                @NotNull
                public ExecutionOrder getExecutionOrder() {
                    return this.$executionOrder;
                }

                public void queue(@NotNull Function0<Unit> action) {
                    Intrinsics.checkNotNullParameter(action, (String)"action");
                    this.tasksInQueue.incrementAndGet();
                    this.$executor.execute(() -> asRdScheduler.1.queue$lambda$0(this, action));
                }

                public void flush() {
                    if (!(!this.isActive())) {
                        boolean $i$a$-require-SchedulerUtilKt$asRdScheduler$1$flush$22 = false;
                        String $i$a$-require-SchedulerUtilKt$asRdScheduler$1$flush$22 = "Can't flush this scheduler in a reentrant way: we are inside queued item's execution";
                        throw new IllegalArgumentException($i$a$-require-SchedulerUtilKt$asRdScheduler$1$flush$22.toString());
                    }
                    boolean $i$f$spinUntil = false;
                    SpinWait.Companion this_$iv$iv = SpinWait.Companion;
                    boolean $i$f$spinUntil2 = false;
                    long spins$iv$iv = 0L;
                    while (true) {
                        boolean bl = false;
                        if (this.tasksInQueue.get() == 0) break;
                        long l = spins$iv$iv;
                        spins$iv$iv = l + 1L;
                        if (l < 100L) {
                            Thread.yield();
                            continue;
                        }
                        Thread.sleep(spins$iv$iv / (long)100);
                    }
                }

                public void assertThread(@Nullable Object debugInfo) {
                    IScheduler.DefaultImpls.assertThread(this, debugInfo);
                }

                public void invokeOrQueue(@NotNull Function0<Unit> action) {
                    IScheduler.DefaultImpls.invokeOrQueue(this, action);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private static final void queue$lambda$0(asRdScheduler.1 this$0, Function0 $action) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
                    int n = this$0.getActive();
                    this$0.setActive(n + 1);
                    try {
                        $action.invoke();
                    }
                    catch (Throwable e) {
                        LoggerKt.error((Logger)Logger.Companion.getRoot(), e);
                    }
                    finally {
                        n = this$0.getActive();
                        this$0.setActive(n + -1);
                        this$0.tasksInQueue.decrementAndGet();
                    }
                }

                static {
                    KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(asRdScheduler.1.class, "active", "getActive()I", 0)))};
                    $$delegatedProperties = kPropertyArray;
                }
            };
        }
        return iScheduler;
    }

    @NotNull
    public static final IScheduler getAsRdScheduler(@NotNull CoroutineDispatcher $this$asRdScheduler) {
        Intrinsics.checkNotNullParameter((Object)$this$asRdScheduler, (String)"<this>");
        IScheduler iScheduler = $this$asRdScheduler instanceof IScheduler ? (IScheduler)$this$asRdScheduler : null;
        if (iScheduler == null) {
            iScheduler = SchedulerUtilKt.getAsRdScheduler(ExecutorsKt.asExecutor((CoroutineDispatcher)$this$asRdScheduler));
        }
        return iScheduler;
    }

    @NotNull
    public static final IScheduler asRdScheduler(@NotNull CoroutineDispatcher $this$asRdScheduler, @NotNull ExecutionOrder dispatcherExecutionOrder) {
        Intrinsics.checkNotNullParameter((Object)$this$asRdScheduler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)dispatcherExecutionOrder), (String)"dispatcherExecutionOrder");
        IScheduler iScheduler = $this$asRdScheduler instanceof IScheduler ? (IScheduler)$this$asRdScheduler : null;
        if (iScheduler == null) {
            iScheduler = SchedulerUtilKt.asRdScheduler(ExecutorsKt.asExecutor((CoroutineDispatcher)$this$asRdScheduler), dispatcherExecutionOrder);
        }
        return iScheduler;
    }

    @NotNull
    public static final IScheduler asSequentialScheduler(@NotNull IScheduler $this$asSequentialScheduler) {
        Intrinsics.checkNotNullParameter((Object)$this$asSequentialScheduler, (String)"<this>");
        if ($this$asSequentialScheduler.getExecutionOrder() == ExecutionOrder.Sequential) {
            return $this$asSequentialScheduler;
        }
        return new SequentialScheduler($this$asSequentialScheduler);
    }
}

