/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/jfr/DllDebugInfo;", "", "dllPath", "", "size", "", "dbgInfo", "", "<init>", "(Ljava/lang/String;J[B)V", "getDllPath", "()Ljava/lang/String;", "getSize", "()J", "getDbgInfo", "()[B", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.profiler.ultimate"})
public final class DllDebugInfo {
    @NotNull
    private final String dllPath;
    private final long size;
    @NotNull
    private final byte[] dbgInfo;

    public DllDebugInfo(@NotNull String dllPath, long size, @NotNull byte[] dbgInfo) {
        Intrinsics.checkNotNullParameter((Object)dllPath, (String)"dllPath");
        Intrinsics.checkNotNullParameter((Object)dbgInfo, (String)"dbgInfo");
        this.dllPath = dllPath;
        this.size = size;
        this.dbgInfo = dbgInfo;
    }

    @NotNull
    public final String getDllPath() {
        return this.dllPath;
    }

    public final long getSize() {
        return this.size;
    }

    @NotNull
    public final byte[] getDbgInfo() {
        return this.dbgInfo;
    }

    @NotNull
    public final String component1() {
        return this.dllPath;
    }

    public final long component2() {
        return this.size;
    }

    @NotNull
    public final byte[] component3() {
        return this.dbgInfo;
    }

    @NotNull
    public final DllDebugInfo copy(@NotNull String dllPath, long size, @NotNull byte[] dbgInfo) {
        Intrinsics.checkNotNullParameter((Object)dllPath, (String)"dllPath");
        Intrinsics.checkNotNullParameter((Object)dbgInfo, (String)"dbgInfo");
        return new DllDebugInfo(dllPath, size, dbgInfo);
    }

    public static /* synthetic */ DllDebugInfo copy$default(DllDebugInfo dllDebugInfo, String string, long l, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = dllDebugInfo.dllPath;
        }
        if ((n & 2) != 0) {
            l = dllDebugInfo.size;
        }
        if ((n & 4) != 0) {
            byArray = dllDebugInfo.dbgInfo;
        }
        return dllDebugInfo.copy(string, l, byArray);
    }

    @NotNull
    public String toString() {
        return "DllDebugInfo(dllPath=" + this.dllPath + ", size=" + this.size + ", dbgInfo=" + Arrays.toString(this.dbgInfo) + ")";
    }

    public int hashCode() {
        int result = this.dllPath.hashCode();
        result = result * 31 + Long.hashCode(this.size);
        result = result * 31 + Arrays.hashCode(this.dbgInfo);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DllDebugInfo)) {
            return false;
        }
        DllDebugInfo dllDebugInfo = (DllDebugInfo)other;
        if (!Intrinsics.areEqual((Object)this.dllPath, (Object)dllDebugInfo.dllPath)) {
            return false;
        }
        if (this.size != dllDebugInfo.size) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dbgInfo, (Object)dllDebugInfo.dbgInfo);
    }
}

