/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.facet.FacetGrid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00130\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001a0\u0013H&J6\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00130\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001a0\u0013H&J \u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00132\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0013H\u0016J \u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00132\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0013H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00132\u0006\u0010\"\u001a\u00020!H&J\u000e\u0010#\u001a\u00020\b2\u0006\u0010\"\u001a\u00020!J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0013H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0012\u0010\u000e\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0012\u0010\u0010\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "", "()V", "colCount", "", "getColCount", "()I", "freeHScale", "", "getFreeHScale", "()Z", "freeVScale", "getFreeVScale", "isDefined", "numTiles", "getNumTiles", "rowCount", "getRowCount", "variables", "", "", "getVariables", "()Ljava/util/List;", "adjustFreeDisctereHDomainsByTile", "domainBeforeFacets", "domainByTile", "", "adjustFreeDisctereVDomainsByTile", "adjustHDomains", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "domains", "adjustVDomains", "dataByTile", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "isFacettable", "tileInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets$FacetTileInfo;", "Companion", "FacetTileInfo", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotFacets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotFacets.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1747#2,3:227\n*S KotlinDebug\n*F\n+ 1 PlotFacets.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets\n*L\n27#1:227,3\n*E\n"})
public abstract class PlotFacets {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DEF_ORDER_DIR = 0;
    @NotNull
    private static final Function1<Object, String> DEF_FORMATTER = Companion.DEF_FORMATTER.1.INSTANCE;
    public static final int DEF_LAB_WIDTH = -1;
    @NotNull
    private static final PlotFacets UNDEFINED = new FacetGrid(null, null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), 1, 1, null, null, null, 0, 0, 1984, null);

    public abstract boolean isDefined();

    public abstract int getColCount();

    public abstract int getRowCount();

    public abstract int getNumTiles();

    @NotNull
    public abstract List<String> getVariables();

    public abstract boolean getFreeHScale();

    public abstract boolean getFreeVScale();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFacettable(@NotNull DataFrame data2) {
        String it;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (data2.isEmpty()) return false;
        if (data2.rowCount() <= 0) return false;
        Iterable $this$any$iv = this.getVariables();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!DataFrameUtil.INSTANCE.hasVariable(data2, it));
        return true;
    }

    @NotNull
    public abstract List<DataFrame> dataByTile(@NotNull DataFrame var1);

    @NotNull
    public abstract List<FacetTileInfo> tileInfos();

    @NotNull
    public List<DoubleSpan> adjustHDomains(@NotNull List<DoubleSpan> domains) {
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        return domains;
    }

    @NotNull
    public List<DoubleSpan> adjustVDomains(@NotNull List<DoubleSpan> domains) {
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        return domains;
    }

    @NotNull
    public abstract List<List<Object>> adjustFreeDisctereHDomainsByTile(@NotNull List<? extends Object> var1, @NotNull List<? extends Collection<? extends Object>> var2);

    @NotNull
    public abstract List<List<Object>> adjustFreeDisctereVDomainsByTile(@NotNull List<? extends Object> var1, @NotNull List<? extends Collection<? extends Object>> var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00110\u00100\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u0010JB\u0010\u0014\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00110\u00100\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u0010H\u0002JH\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0010\u0012\u0004\u0012\u00020\u00160\u00110\u00102\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u0010JP\u0010\u0018\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\u00190\u00192\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u0010H\u0002JB\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u0010J,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u001f\u001a\u00020\tR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets$Companion;", "", "()V", "DEF_FORMATTER", "Lkotlin/Function1;", "", "getDEF_FORMATTER", "()Lkotlin/jvm/functions/Function1;", "DEF_LAB_WIDTH", "", "DEF_ORDER_DIR", "UNDEFINED", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "getUNDEFINED", "()Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "createNameLevelTuples", "", "Lkotlin/Pair;", "varNames", "varLevels", "createNameLevelTuplesIntern", "dataByLevelTuple", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "dataIndicesByVarByLevel", "", "reorderLevels", "ordering", "reorderVarLevels", "name", "levels", "order", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nPlotFacets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotFacets.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1549#2:227\n1620#2,3:228\n1#3:231\n*S KotlinDebug\n*F\n+ 1 PlotFacets.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets$Companion\n*L\n96#1:227\n96#1:228,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Object, String> getDEF_FORMATTER() {
            return DEF_FORMATTER;
        }

        @NotNull
        public final PlotFacets getUNDEFINED() {
            return UNDEFINED;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<List<Object>, DataFrame>> dataByLevelTuple(@NotNull DataFrame data2, @NotNull List<String> varNames, @NotNull List<? extends List<? extends Object>> varLevels) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter(varNames, (String)"varNames");
            Intrinsics.checkNotNullParameter(varLevels, (String)"varLevels");
            List<List<Pair<String, Object>>> nameLevelTuples = this.createNameLevelTuples(varNames, varLevels);
            Map<String, Map<Object, List<Integer>>> indicesByVarByLevel = this.dataIndicesByVarByLevel(data2, varNames, varLevels);
            ArrayList<Pair> dataByLevelKey = new ArrayList<Pair>();
            for (List<Pair<String, Object>> nameLevelTuple : nameLevelTuples) {
                void $this$mapTo$iv$iv;
                Object level;
                String topName = (String)((Pair)CollectionsKt.first(nameLevelTuple)).getFirst();
                Object topLevel = ((Pair)CollectionsKt.first(nameLevelTuple)).getSecond();
                ArrayList indices2 = new ArrayList((Collection)MapsKt.getValue((Map)((Map)MapsKt.getValue(indicesByVarByLevel, (Object)topName)), (Object)topLevel));
                int n = nameLevelTuple.size();
                for (int i = 1; i < n; ++i) {
                    String name = (String)nameLevelTuple.get(i).getFirst();
                    level = nameLevelTuple.get(i).getSecond();
                    List levelIndices = (List)MapsKt.getValue((Map)((Map)MapsKt.getValue(indicesByVarByLevel, (Object)name)), (Object)level);
                    indices2.retainAll(new HashSet(levelIndices));
                }
                Iterable $this$map$iv = nameLevelTuple;
                boolean $i$f$map = false;
                level = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getSecond());
                }
                List levelKey = (List)destination$iv$iv;
                DataFrame levelData = data2.slice(indices2);
                dataByLevelKey.add(TuplesKt.to((Object)levelKey, (Object)levelData));
            }
            return dataByLevelKey;
        }

        private final Map<String, Map<Object, List<Integer>>> dataIndicesByVarByLevel(DataFrame data2, List<String> varNames, List<? extends List<? extends Object>> varLevels) {
            HashMap indicesByVarByLevel = new HashMap();
            Iterator<String> iterator2 = varNames.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                String varName = iterator2.next();
                List<? extends Object> levels = varLevels.get(i);
                HashMap indicesByLevel = new HashMap();
                for (Object object : levels) {
                    List<Integer> list2;
                    if (data2.isEmpty()) {
                        list2 = CollectionsKt.emptyList();
                    } else if (DataFrameUtil.INSTANCE.hasVariable(data2, varName)) {
                        DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data2, varName);
                        list2 = SeriesUtil.INSTANCE.matchingIndices(data2.get(variable), object);
                    } else {
                        list2 = CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)data2.rowCount())));
                    }
                    List<Integer> indices2 = list2;
                    ((Map)indicesByLevel).put(object, indices2);
                }
                ((Map)indicesByVarByLevel).put(varName, indicesByLevel);
            }
            return indicesByVarByLevel;
        }

        @NotNull
        public final List<List<Pair<String, Object>>> createNameLevelTuples(@NotNull List<String> varNames, @NotNull List<? extends List<? extends Object>> varLevels) {
            Intrinsics.checkNotNullParameter(varNames, (String)"varNames");
            Intrinsics.checkNotNullParameter(varLevels, (String)"varLevels");
            if (!(!((Collection)varNames).isEmpty())) {
                boolean $i$a$-require-PlotFacets$Companion$createNameLevelTuples$32 = false;
                String $i$a$-require-PlotFacets$Companion$createNameLevelTuples$32 = "Empty list of facet variables.";
                throw new IllegalArgumentException($i$a$-require-PlotFacets$Companion$createNameLevelTuples$32.toString());
            }
            if (!(varNames.size() == CollectionsKt.distinct((Iterable)varNames).size())) {
                boolean bl = false;
                String string = "Facet variables must be distinct, were: " + varNames + '.';
                throw new IllegalArgumentException(string.toString());
            }
            if (!(varNames.size() == varLevels.size())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            return this.createNameLevelTuplesIntern(varNames, varLevels);
        }

        private final List<List<Pair<String, Object>>> createNameLevelTuplesIntern(List<String> varNames, List<? extends List<? extends Object>> varLevels) {
            String name = (String)CollectionsKt.first(varNames);
            List levels = (List)CollectionsKt.first(varLevels);
            ArrayList<List> levelKeys = new ArrayList<List>();
            for (Object level : levels) {
                if (varNames.size() > 1) {
                    List<List<Pair<String, Object>>> subKeys = this.createNameLevelTuples(varNames.subList(1, varNames.size()), varLevels.subList(1, varLevels.size()));
                    for (List<Pair<String, Object>> subKey : subKeys) {
                        levelKeys.add(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)TuplesKt.to((Object)name, level)), (Iterable)subKey));
                    }
                    continue;
                }
                levelKeys.add(CollectionsKt.listOf((Object)TuplesKt.to((Object)name, level)));
            }
            return levelKeys;
        }

        @NotNull
        public final List<List<Object>> reorderLevels(@NotNull List<String> varNames, @NotNull List<? extends List<? extends Object>> varLevels, @NotNull List<Integer> ordering) {
            Intrinsics.checkNotNullParameter(varNames, (String)"varNames");
            Intrinsics.checkNotNullParameter(varLevels, (String)"varLevels");
            Intrinsics.checkNotNullParameter(ordering, (String)"ordering");
            Map orderingByFacet = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)varNames, (Iterable)ordering));
            ArrayList<List<Object>> result2 = new ArrayList<List<Object>>();
            Iterator<String> iterator2 = varNames.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                String name = iterator2.next();
                if (i >= varLevels.size()) break;
                result2.add(this.reorderVarLevels(name, varLevels.get(i), ((Number)MapsKt.getValue((Map)orderingByFacet, (Object)name)).intValue()));
            }
            return result2;
        }

        @NotNull
        public final List<Object> reorderVarLevels(@Nullable String name, @NotNull List<? extends Object> levels, int order) {
            Intrinsics.checkNotNullParameter(levels, (String)"levels");
            if (name == null) {
                return levels;
            }
            return order <= -1 ? CollectionsKt.sortedDescending((Iterable)levels) : (order >= 1 ? CollectionsKt.sorted((Iterable)levels) : levels);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets$FacetTileInfo;", "", "col", "", "row", "colLabs", "", "", "rowLab", "hasHAxis", "", "hasVAxis", "isBottom", "trueIndex", "(IILjava/util/List;Ljava/lang/String;ZZZI)V", "getCol", "()I", "getColLabs", "()Ljava/util/List;", "getHasHAxis", "()Z", "getHasVAxis", "getRow", "getRowLab", "()Ljava/lang/String;", "getTrueIndex", "toString", "plot-builder"})
    public static final class FacetTileInfo {
        private final int col;
        private final int row;
        @NotNull
        private final List<String> colLabs;
        @Nullable
        private final String rowLab;
        private final boolean hasHAxis;
        private final boolean hasVAxis;
        private final boolean isBottom;
        private final int trueIndex;

        public FacetTileInfo(int col, int row, @NotNull List<String> colLabs, @Nullable String rowLab, boolean hasHAxis, boolean hasVAxis, boolean isBottom, int trueIndex) {
            Intrinsics.checkNotNullParameter(colLabs, (String)"colLabs");
            this.col = col;
            this.row = row;
            this.colLabs = colLabs;
            this.rowLab = rowLab;
            this.hasHAxis = hasHAxis;
            this.hasVAxis = hasVAxis;
            this.isBottom = isBottom;
            this.trueIndex = trueIndex;
        }

        public final int getCol() {
            return this.col;
        }

        public final int getRow() {
            return this.row;
        }

        @NotNull
        public final List<String> getColLabs() {
            return this.colLabs;
        }

        @Nullable
        public final String getRowLab() {
            return this.rowLab;
        }

        public final boolean getHasHAxis() {
            return this.hasHAxis;
        }

        public final boolean getHasVAxis() {
            return this.hasVAxis;
        }

        public final boolean isBottom() {
            return this.isBottom;
        }

        public final int getTrueIndex() {
            return this.trueIndex;
        }

        @NotNull
        public String toString() {
            return "FacetTileInfo(col=" + this.col + ", row=" + this.row + ", colLabs=" + this.colLabs + ", rowLab=" + this.rowLab + ')';
        }
    }
}

