/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.util.LinkedList;
import java.util.List;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.CSSFontFace;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.ErrorConstants;
import org.jetbrains.relocated.apache.batik.bridge.FontFamilyResolver;
import org.jetbrains.relocated.apache.batik.bridge.SVGFontFace;
import org.jetbrains.relocated.apache.batik.bridge.SVGFontFaceElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.SVGFontFamily;
import org.jetbrains.relocated.apache.batik.bridge.UserAgent;
import org.jetbrains.relocated.apache.batik.dom.AbstractNode;
import org.jetbrains.relocated.apache.batik.gvt.font.GVTFontFace;
import org.jetbrains.relocated.apache.batik.gvt.font.GVTFontFamily;
import org.jetbrains.relocated.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public abstract class FontFace
extends GVTFontFace
implements ErrorConstants {
    List srcs;

    public FontFace(List srcs, String familyName, float unitsPerEm, String fontWeight, String fontStyle, String fontVariant, String fontStretch, float slope, String panose1, float ascent, float descent, float strikethroughPosition, float strikethroughThickness, float underlinePosition, float underlineThickness, float overlinePosition, float overlineThickness) {
        super(familyName, unitsPerEm, fontWeight, fontStyle, fontVariant, fontStretch, slope, panose1, ascent, descent, strikethroughPosition, strikethroughThickness, underlinePosition, underlineThickness, overlinePosition, overlineThickness);
        this.srcs = srcs;
    }

    protected FontFace(String familyName) {
        super(familyName);
    }

    public static CSSFontFace createFontFace(String familyName, FontFace src) {
        return new CSSFontFace(new LinkedList(src.srcs), familyName, src.unitsPerEm, src.fontWeight, src.fontStyle, src.fontVariant, src.fontStretch, src.slope, src.panose1, src.ascent, src.descent, src.strikethroughPosition, src.strikethroughThickness, src.underlinePosition, src.underlineThickness, src.overlinePosition, src.overlineThickness);
    }

    public GVTFontFamily getFontFamily(BridgeContext ctx2) {
        FontFamilyResolver fontFamilyResolver = ctx2.getFontFamilyResolver();
        GVTFontFamily family = fontFamilyResolver.resolve(this.familyName, this);
        if (family != null) {
            return family;
        }
        for (Object o : this.srcs) {
            if (o instanceof String) {
                family = fontFamilyResolver.resolve((String)o, this);
                if (family == null) continue;
                return family;
            }
            if (!(o instanceof ParsedURL)) continue;
            try {
                GVTFontFamily ff = this.getFontFamily(ctx2, (ParsedURL)o);
                if (ff == null) continue;
                return ff;
            }
            catch (SecurityException ex) {
                ctx2.getUserAgent().displayError(ex);
            }
            catch (BridgeException ex) {
                if (!"uri.unsecure".equals(ex.getCode())) continue;
                ctx2.getUserAgent().displayError(ex);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    protected GVTFontFamily getFontFamily(BridgeContext ctx2, ParsedURL purl) {
        String purlStr = purl.toString();
        Element e = this.getBaseElement(ctx2);
        SVGDocument svgDoc = (SVGDocument)e.getOwnerDocument();
        String docURL = svgDoc.getURL();
        ParsedURL pDocURL = null;
        if (docURL != null) {
            pDocURL = new ParsedURL(docURL);
        }
        String baseURI = AbstractNode.getBaseURI(e);
        purl = new ParsedURL(baseURI, purlStr);
        UserAgent userAgent = ctx2.getUserAgent();
        try {
            userAgent.checkLoadExternalResource(purl, pDocURL);
        }
        catch (SecurityException ex) {
            userAgent.displayError(ex);
            return null;
        }
        if (purl.getRef() != null) {
            Element ref = ctx2.getReferencedElement(e, purlStr);
            if (!ref.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !ref.getLocalName().equals("font")) {
                return null;
            }
            SVGDocument doc = (SVGDocument)e.getOwnerDocument();
            SVGDocument rdoc = (SVGDocument)ref.getOwnerDocument();
            Element fontElt = ref;
            if (doc != rdoc) {
                fontElt = (Element)doc.importNode((Node)ref, true);
                String base = AbstractNode.getBaseURI(ref);
                Element g = doc.createElementNS("http://www.w3.org/2000/svg", "g");
                g.appendChild(fontElt);
                g.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", base);
                CSSUtilities.computeStyleAndURIs(ref, fontElt, purlStr);
            }
            Element fontFaceElt = null;
            for (Node n = fontElt.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !n.getLocalName().equals("font-face")) continue;
                fontFaceElt = (Element)n;
                break;
            }
            SVGFontFaceElementBridge fontFaceBridge = (SVGFontFaceElementBridge)ctx2.getBridge("http://www.w3.org/2000/svg", "font-face");
            SVGFontFace gff = fontFaceBridge.createFontFace(ctx2, fontFaceElt);
            return new SVGFontFamily(gff, fontElt, ctx2);
        }
        try {
            return ctx2.getFontFamilyResolver().loadFont(purl.openStream(), this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Element getBaseElement(BridgeContext ctx2) {
        SVGDocument d = (SVGDocument)ctx2.getDocument();
        return d.getRootElement();
    }
}

