/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder;

import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.Range;
import org.jetbrains.annotations.NotNull;

public class Seg {
    public static final Seg NULL = new Seg(Range.NULL.getStart(), Range.NULL.getEnd());
    public static final Seg ANCHOR_0 = new Seg(0, 0);
    public static final int MAX_TEXT_OFFSET = 0x3FFFFFFF;
    public static final int F_TEXT_OPTION = 0x40000000;
    private final int start;
    private final int end;

    private Seg(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getSegStart() {
        return this.isText() ? this.getTextStart() : this.start;
    }

    public int getSegEnd() {
        return this.isText() ? this.getTextEnd() : this.end;
    }

    public int getTextStart() {
        return Seg.getTextOffset(this.start);
    }

    public static int getTextOffset(int startOffset) {
        return -startOffset - 1 & 0x3FFFFFFF;
    }

    public int getTextEnd() {
        return Seg.getTextOffset(this.end);
    }

    public boolean isFirst256Start() {
        return Seg.isFirst256Start(this.start);
    }

    public static boolean isFirst256Start(int start) {
        return (-start - 1 & 0x40000000) != 0;
    }

    public boolean isRepeatedTextEnd() {
        return Seg.isRepeatedTextEnd(this.end);
    }

    public static boolean isRepeatedTextEnd(int end) {
        return (-end - 1 & 0x40000000) != 0;
    }

    public boolean isText() {
        return this.start < 0 && this.end < 0 && (this.start & 0x3FFFFFFF) > (this.end & 0x3FFFFFFF);
    }

    public boolean isBase() {
        return this.start >= 0 && this.end >= 0 && this.start <= this.end;
    }

    public boolean isAnchor() {
        return this.start >= 0 && this.end >= 0 && this.start == this.end;
    }

    public boolean isNull() {
        return !this.isBase() && !this.isText();
    }

    @NotNull
    public Range getRange() {
        assert (this.isBase());
        return Range.of(this.start, this.end);
    }

    public int length() {
        return this.isBase() ? this.end - this.start : (this.isText() ? (this.start & 0x3FFFFFFF) - (this.end & 0x3FFFFFFF) : 0);
    }

    public String toString(@NotNull CharSequence allText) {
        String chars;
        if (this.isNull()) {
            return "NULL";
        }
        if (this.isBase()) {
            if (this.start == this.end) {
                return "[" + this.start + ")";
            }
            return "[" + this.start + ", " + this.end + ")";
        }
        CharSequence charSequence = allText.subSequence(this.getTextStart(), this.getTextEnd());
        if (this.isRepeatedTextEnd() && this.length() > 1) {
            if (this.isFirst256Start()) {
                return "a:" + this.length() + "x'" + Utils.escapeJavaString(charSequence.subSequence(0, 1)) + "'";
            }
            return this.length() + "x'" + Utils.escapeJavaString(charSequence.subSequence(0, 1)) + "'";
        }
        String string = chars = this.length() <= 20 ? charSequence.toString() : charSequence.subSequence(0, 10).toString() + "\u2026" + charSequence.subSequence(this.length() - 10, this.length()).toString();
        if (this.isFirst256Start()) {
            return "a:'" + Utils.escapeJavaString(chars) + "'";
        }
        return "'" + Utils.escapeJavaString(chars) + "'";
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.isBase()) {
            if (this.start == this.end) {
                return "BASE[" + this.start + ")";
            }
            return "BASE[" + this.start + ", " + this.end + ")";
        }
        return "TEXT[" + this.getTextStart() + ", " + this.getTextEnd() + ")";
    }

    @NotNull
    public static Seg segOf(int startOffset, int endOffset) {
        return startOffset == 0 && endOffset == 0 ? ANCHOR_0 : new Seg(startOffset, endOffset);
    }

    public static int getTextStart(int startOffset, boolean isFirst256) {
        assert (startOffset < 0x3FFFFFFF);
        return -(isFirst256 ? startOffset | 0x40000000 : startOffset) - 1;
    }

    public static int getTextEnd(int startOffset, boolean isRepeatedText) {
        assert (startOffset < 0x3FFFFFFF);
        return -(isRepeatedText ? startOffset | 0x40000000 : startOffset) - 1;
    }

    @NotNull
    public static Seg textOf(int startOffset, int endOffset, boolean isFirst256, boolean isRepeatedText) {
        return new Seg(Seg.getTextStart(startOffset, isFirst256), Seg.getTextEnd(endOffset, isRepeatedText));
    }
}

