/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;
import org.jetbrains.qodana.cloud.QodanaCloudDefaultUrlsKt;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.cloud.UserState;
import org.jetbrains.qodana.cloud.authorization.LicenseAcceptedResponse;
import org.jetbrains.qodana.coroutines.LifetimeKt;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.registry.QodanaRegistry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\"\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaLicenseAgreementHandler;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "isMethodSupported", "", "method", "Lio/netty/handler/codec/http/HttpMethod;", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaLicenseAgreementHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaLicenseAgreementHandler.kt\norg/jetbrains/qodana/cloud/authorization/QodanaLicenseAgreementHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class QodanaLicenseAgreementHandler
extends RestService {
    @NotNull
    protected String getServiceName() {
        return "qodana/license-agreement";
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST);
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = NettyKt.getOrigin((HttpRequest)request);
        if (string != null) {
            String it = string;
            boolean bl = false;
            url = Urls.newFromEncoded((String)it);
        } else {
            url = null;
        }
        return Intrinsics.areEqual(url, (Object)QodanaCloudDefaultUrlsKt.currentQodanaCloudFrontendUrl()) ? HttpRequestHandler.OriginCheckResult.ALLOW : HttpRequestHandler.OriginCheckResult.FORBID;
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!QodanaRegistry.INSTANCE.isQodanaLicenseAgreementCallbackEnabled()) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            RestService.Companion.sendStatus(httpResponseStatus, false, channel);
            return null;
        }
        UserState userState = (UserState)QodanaCloudStateService.Companion.getInstance().getUserState().getValue();
        UserState userState2 = userState;
        if (userState2 instanceof UserState.Authorized) {
            RestService.Companion.sendOk(request, context);
        } else if (userState2 instanceof UserState.Authorizing) {
            Gson gson = new GsonBuilder().create();
            LicenseAcceptedResponse response2 = (LicenseAcceptedResponse)gson.fromJson(RestService.Companion.createJsonReader(request), (Type)((Object)LicenseAcceptedResponse.class));
            BuildersKt.launch$default((CoroutineScope)LifetimeKt.getQodanaApplicationScope(), (CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getDefault(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(userState, response2, null){
                int label;
                final /* synthetic */ UserState $userState;
                final /* synthetic */ LicenseAcceptedResponse $response;
                {
                    this.$userState = $userState;
                    this.$response = $response;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = ((UserState.Authorizing)this.$userState).licenseAgreementAcceptedCallback(this.$response.getUserId(), this.$response.getAccepted(), (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            RestService.Companion.sendOk(request, context);
        } else if (userState2 instanceof UserState.NotAuthorized) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            RestService.Companion.sendStatus(httpResponseStatus, false, channel);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }
}

