/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.psi.impl;

import com.intellij.debugger.streams.core.psi.DebuggerPositionResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerPositionResolverImpl
implements DebuggerPositionResolver {
    @Override
    @Nullable
    public PsiElement getNearestElementToBreakpoint(@NotNull XDebugSession session) {
        XSourcePosition position;
        if (session == null) {
            DebuggerPositionResolverImpl.$$$reportNull$$$0(0);
        }
        if ((position = session.getCurrentPosition()) == null) {
            return null;
        }
        int offset = position.getOffset();
        VirtualFile file = position.getFile();
        if (file.isValid() && 0 <= offset && (long)offset < file.getLength()) {
            @Nullable PsiFile psiFile = PsiManager.getInstance((Project)session.getProject()).findFile(file);
            return psiFile != null ? psiFile.findElementAt(offset) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/streams/core/psi/impl/DebuggerPositionResolverImpl", "getNearestElementToBreakpoint"));
    }
}

