/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleKt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TtyConnector;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.block.TerminalContentView;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016J\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0013H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/terminal/block/OldPlainTerminalView;", "Lorg/jetbrains/plugins/terminal/block/TerminalContentView;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;Lcom/intellij/terminal/TerminalTitle;)V", "widget", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "connectToTty", "", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "getTerminalSize", "getTerminalSizeInitializedFuture", "Ljava/util/concurrent/CompletableFuture;", "isFocused", "", "addTerminationCallback", "onTerminated", "Ljava/lang/Runnable;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "sendCommandToExecute", "shellCommand", "", "getText", "", "dispose", "intellij.terminal"})
public final class OldPlainTerminalView
implements TerminalContentView {
    @NotNull
    private final ShellTerminalWidget widget;

    public OldPlainTerminalView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProvider settings, @NotNull TerminalTitle terminalTitle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)terminalTitle, (String)"terminalTitle");
        this.widget = new ShellTerminalWidget(project, settings, (Disposable)this);
        Terminal terminal = this.widget.getTerminal();
        Intrinsics.checkNotNullExpressionValue((Object)terminal, (String)"getTerminal(...)");
        TerminalTitleKt.bindApplicationTitle((TerminalTitle)terminalTitle, (Terminal)terminal, (Disposable)this);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.widget.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent = this.widget.getPreferredFocusableComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getPreferredFocusableComponent(...)");
        return jComponent;
    }

    @Override
    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        this.widget.asNewWidget().connectToTty(ttyConnector, initialTermSize);
    }

    @Override
    @Nullable
    public TermSize getTerminalSize() {
        return this.widget.getTerminalPanel().getTerminalSizeFromComponent();
    }

    @Override
    @NotNull
    public CompletableFuture<?> getTerminalSizeInitializedFuture() {
        return TerminalUiUtils.INSTANCE.getComponentSizeInitializedFuture(this.getComponent());
    }

    @Override
    public boolean isFocused() {
        return this.widget.getTerminalPanel().hasFocus();
    }

    @Override
    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.widget.asNewWidget().addTerminationCallback(onTerminated, parentDisposable);
    }

    @Override
    public void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.widget.executeCommand(shellCommand);
    }

    @Override
    @NotNull
    public CharSequence getText() {
        String string = this.widget.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public void dispose() {
    }
}

