/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.PlaceholderEntry;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.TwoOopHashtable;

public class PlaceholderTable
extends TwoOopHashtable {
    public PlaceholderTable(Address addr) {
        super(addr);
    }

    @Override
    protected Class getHashtableEntryClass() {
        return PlaceholderEntry.class;
    }

    public void primArrayClassesDo(SystemDictionary.ClassAndLoaderVisitor v) {
        ObjectHeap heap = VM.getVM().getObjectHeap();
        int tblSize = this.tableSize();
        for (int index = 0; index < tblSize; ++index) {
            for (PlaceholderEntry probe = (PlaceholderEntry)this.bucket(index); probe != null; probe = (PlaceholderEntry)probe.next()) {
                FieldType.ArrayInfo info;
                Symbol sym = probe.klass();
                FieldType ft = new FieldType(sym);
                if (!ft.isArray() || (info = ft.getArrayInfo()).elementBasicType() == BasicType.getTObject()) continue;
                Klass arrayKlass = heap.typeArrayKlassObj(info.elementBasicType());
                arrayKlass = arrayKlass.arrayKlassOrNull(info.dimension());
                v.visit(arrayKlass, probe.loader());
            }
        }
    }
}

