/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import jakarta.persistence.EnumType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractResultSetAccess
implements ResultSetAccess {
    private final SharedSessionContractImplementor persistenceContext;
    private ResultSetMetaData resultSetMetaData;

    public AbstractResultSetAccess(SharedSessionContractImplementor persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    protected abstract SessionFactoryImplementor getFactory();

    protected SharedSessionContractImplementor getPersistenceContext() {
        return this.persistenceContext;
    }

    private SqlExceptionHelper getSqlExceptionHelper() {
        return this.getFactory().getJdbcServices().getSqlExceptionHelper();
    }

    private Dialect getDialect() {
        return this.getFactory().getJdbcServices().getDialect();
    }

    private ResultSetMetaData getResultSetMetaData() {
        if (this.resultSetMetaData == null) {
            try {
                this.resultSetMetaData = this.getResultSet().getMetaData();
            }
            catch (SQLException e) {
                throw this.getSqlExceptionHelper().convert(e, "Unable to access ResultSetMetaData");
            }
        }
        return this.resultSetMetaData;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.getResultSetMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw this.getSqlExceptionHelper().convert(e, "Unable to access ResultSet column count");
        }
    }

    @Override
    public int resolveColumnPosition(String columnName) {
        try {
            return this.getResultSet().findColumn(this.normalizeColumnName(columnName));
        }
        catch (SQLException e) {
            throw this.getSqlExceptionHelper().convert(e, "Unable to find column position by name: " + columnName);
        }
    }

    private String normalizeColumnName(String columnName) {
        return this.getFactory().getJdbcServices().getJdbcEnvironment().getIdentifierHelper().toMetaDataObjectName(Identifier.toIdentifier(columnName));
    }

    @Override
    public String resolveColumnName(int position) {
        try {
            return this.getDialect().getColumnAliasExtractor().extractColumnAlias(this.getResultSetMetaData(), position);
        }
        catch (SQLException e) {
            throw this.getSqlExceptionHelper().convert(e, "Unable to find column name by position");
        }
    }

    @Override
    public int getResultCountEstimate() {
        return -1;
    }

    @Override
    public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
        try {
            ResultSetMetaData metaData = this.getResultSetMetaData();
            JdbcTypeRegistry registry = typeConfiguration.getJdbcTypeRegistry();
            String columnTypeName = metaData.getColumnTypeName(position);
            int columnType = metaData.getColumnType(position);
            int scale = metaData.getScale(position);
            int precision = metaData.getPrecision(position);
            int displaySize = metaData.getColumnDisplaySize(position);
            Dialect dialect = this.getDialect();
            int length = dialect.resolveSqlTypeLength(columnTypeName, columnType, precision, scale, displaySize);
            JdbcType resolvedJdbcType = dialect.resolveSqlTypeDescriptor(columnTypeName, columnType, length, scale, registry);
            JdbcType jdbcType = explicitJavaType == null ? resolvedJdbcType : this.jdbcType(explicitJavaType, resolvedJdbcType, length, precision, scale, typeConfiguration);
            JavaType<J> javaType = explicitJavaType == null ? jdbcType.getJdbcRecommendedJavaTypeMapping(length, scale, typeConfiguration) : explicitJavaType;
            return typeConfiguration.getBasicTypeRegistry().resolve(javaType, jdbcType);
        }
        catch (SQLException e) {
            throw this.getSqlExceptionHelper().convert(e, "Unable to determine JDBC type code for ResultSet position " + position);
        }
    }

    private <J> JdbcType jdbcType(JavaType<J> javaType, final JdbcType resolvedJdbcType, final int length, final int precision, final int scale, final TypeConfiguration typeConfiguration) {
        return javaType.getRecommendedJdbcType(new JdbcTypeIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public long getColumnLength() {
                return length;
            }

            @Override
            public int getColumnPrecision() {
                return precision;
            }

            @Override
            public int getColumnScale() {
                return scale;
            }

            @Override
            public EnumType getEnumeratedType() {
                return resolvedJdbcType.isNumber() ? EnumType.ORDINAL : EnumType.STRING;
            }

            @Override
            public Dialect getDialect() {
                return AbstractResultSetAccess.this.getDialect();
            }
        });
    }
}

