/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.logs.LogMarshaler;
import io.opentelemetry.proto.logs.v1.internal.LogRecord;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import java.io.IOException;

final class LogStatelessMarshaler
implements StatelessMarshaler<LogRecordData> {
    private static final String INVALID_TRACE_ID = TraceId.getInvalid();
    private static final String INVALID_SPAN_ID = SpanId.getInvalid();
    static final LogStatelessMarshaler INSTANCE = new LogStatelessMarshaler();

    LogStatelessMarshaler() {
    }

    public void writeTo(Serializer output, LogRecordData log, MarshalerContext context) throws IOException {
        output.serializeFixed64(LogRecord.TIME_UNIX_NANO, log.getTimestampEpochNanos());
        output.serializeFixed64(LogRecord.OBSERVED_TIME_UNIX_NANO, log.getObservedTimestampEpochNanos());
        output.serializeEnum(LogRecord.SEVERITY_NUMBER, LogMarshaler.toProtoSeverityNumber(log.getSeverity()));
        output.serializeStringWithContext(LogRecord.SEVERITY_TEXT, log.getSeverityText(), context);
        if (log.getBodyValue() != null) {
            output.serializeMessageWithContext(LogRecord.BODY, (Object)log.getBodyValue(), (StatelessMarshaler)AnyValueStatelessMarshaler.INSTANCE, context);
        }
        output.serializeRepeatedMessageWithContext(LogRecord.ATTRIBUTES, log.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = log.getTotalAttributeCount() - log.getAttributes().size();
        output.serializeUInt32(LogRecord.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        SpanContext spanContext = log.getSpanContext();
        output.serializeFixed32(LogRecord.FLAGS, (int)spanContext.getTraceFlags().asByte());
        if (!spanContext.getTraceId().equals(INVALID_TRACE_ID)) {
            output.serializeTraceId(LogRecord.TRACE_ID, spanContext.getTraceId(), context);
        }
        if (!spanContext.getSpanId().equals(INVALID_SPAN_ID)) {
            output.serializeSpanId(LogRecord.SPAN_ID, spanContext.getSpanId(), context);
        }
    }

    public int getBinarySerializedSize(LogRecordData log, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)LogRecord.TIME_UNIX_NANO, (long)log.getTimestampEpochNanos());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)LogRecord.OBSERVED_TIME_UNIX_NANO, (long)log.getObservedTimestampEpochNanos());
        size += MarshalerUtil.sizeEnum((ProtoFieldInfo)LogRecord.SEVERITY_NUMBER, (ProtoEnumInfo)LogMarshaler.toProtoSeverityNumber(log.getSeverity()));
        size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)LogRecord.SEVERITY_TEXT, (String)log.getSeverityText(), (MarshalerContext)context);
        if (log.getBodyValue() != null) {
            size += StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)LogRecord.BODY, (Object)log.getBodyValue(), (StatelessMarshaler)AnyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        }
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)LogRecord.ATTRIBUTES, (Attributes)log.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        int droppedAttributesCount = log.getTotalAttributeCount() - log.getAttributes().size();
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)LogRecord.DROPPED_ATTRIBUTES_COUNT, (int)droppedAttributesCount);
        SpanContext spanContext = log.getSpanContext();
        size += MarshalerUtil.sizeFixed32((ProtoFieldInfo)LogRecord.FLAGS, (int)spanContext.getTraceFlags().asByte());
        if (!spanContext.getTraceId().equals(INVALID_TRACE_ID)) {
            size += MarshalerUtil.sizeTraceId((ProtoFieldInfo)LogRecord.TRACE_ID, (String)spanContext.getTraceId());
        }
        if (!spanContext.getSpanId().equals(INVALID_SPAN_ID)) {
            size += MarshalerUtil.sizeSpanId((ProtoFieldInfo)LogRecord.SPAN_ID, (String)spanContext.getSpanId());
        }
        return size;
    }
}

