/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IdempotentPredicate
implements Predicate {
    public static final IdempotentPredicate INSTANCE = new IdempotentPredicate();
    private static final Set<String> METHODS;

    @Override
    public boolean resolve(HttpServerExchange value) {
        return METHODS.contains(value.getRequestMethod());
    }

    static {
        HashSet<String> methods = new HashSet<String>();
        methods.add("GET");
        methods.add("DELETE");
        methods.add("PUT");
        methods.add("HEAD");
        methods.add("OPTIONS");
        METHODS = Collections.unmodifiableSet(methods);
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "idempotent";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            return INSTANCE;
        }
    }
}

