/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.EmbeddedIdJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class EmbeddedIdAttributeProcessing {
    public static MutableMemberDetails processEmbeddedIdAttribute(JaxbEmbeddedIdImpl jaxbEmbeddedId, MutableClassDetails classDetails, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbEmbeddedId.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbEmbeddedId.getName(), accessType, classDetails);
        EmbeddedIdJpaAnnotation idAnn = (EmbeddedIdJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDED_ID, xmlDocumentContext.getModelBuildingContext()));
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbEmbeddedId, memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbEmbeddedId.getTarget())) {
            TargetXmlAnnotation targetAnn = (TargetXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
            targetAnn.value(XmlAnnotationHelper.determineTargetName(jaxbEmbeddedId.getTarget(), xmlDocumentContext));
        }
        XmlAnnotationHelper.applyAttributeOverrides(jaxbEmbeddedId.getAttributeOverrides(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

