/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.infinispan.quarkus.hibernate.cache.AbstractDomainDataAccess;
import org.infinispan.quarkus.hibernate.cache.DomainDataRegionImpl;
import org.infinispan.quarkus.hibernate.cache.InternalDataAccess;

final class CollectionDataAccessImpl
extends AbstractDomainDataAccess
implements CollectionDataAccess {
    private final AccessType accessType;

    CollectionDataAccessImpl(AccessType accessType, InternalDataAccess internal, DomainDataRegionImpl region) {
        super(internal, region);
        this.accessType = accessType;
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createCollectionKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getCollectionId(cacheKey);
    }

    public AccessType getAccessType() {
        return this.accessType;
    }
}

